<?php

namespace App\Http\Controllers\Admin\Master;
use App\Models\Accounts;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AccountController extends Controller
{
    #Bind view
     protected $view = 'admin.master.account.';


     #Bind account model
     protected $account;

     public function __construct(
                        
        Accounts $account

                        )
     {
        $this->account               = $account;
     } 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function index(Request $request)
    {
          try
        { 
             $input = $request->all();
             $accounts   =  $this->account->where('id','<>',null);
              if(isset($input['search_heading'])){

                if(isset($input['search_heading']) ){
                    $accounts->where('heading','LIKE','%'.$input['search_heading'].'%');
                }
                
            } 
            $details['lists'] = $accounts->orderBy('id', 'DESC')->paginate(50);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {    
             $details['account'] = $this->account->where('status',1)->get();
             
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $account                             = new Accounts(); 
            $account->heading                    = $request->heading ;
            $account->image                   =isset($request->image) ? fileUpload('public/admin/master/account', $request->file('image')) : '';
            $account->description              = $request->description;
            $account->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/account');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->account->whereId($id)->first();
            
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{

            $validate = Validator::make($request->all(), [
               
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $account                         = Accounts::find($id);
            $account->heading                    = $request->heading ;
            if(isset($request->image))
            $account->image           =isset($request->image) ? fileUpload('public/admin/master/account', $request->file('image')) : '';
            
            $account->description           = $request->description ;
            $account->save();
        
            
             toastr()->success('Update Successfully');
            return redirect('/master/account');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $caste = $this->account::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/account');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

         #get the detail of requested resources
        $accounts = $this->account->whereId($request->id)->first();

        if($accounts->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->account->whereId($request->id)->update($data);
          $accounts = $this->account->whereId($request->id)->first();
          $message = $accounts->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/account');
    }
}
