<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\AccountInquiryForms;
use App\Models\PersonalInfoForms;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AccountInquiryFormController extends Controller
{
    #Bind view
    protected $view = 'admin.master.accountinquiryform.';


    #Bind accountinquiryform model
    protected $accountinquiryform;

    public function __construct(

        AccountInquiryForms $accountinquiryform,
        PersonalInfoForms $personalinfoform

    ) {
        $this->accountinquiryform               = $accountinquiryform;
        $this->personalinfoform                = $personalinfoform;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        try {
            $input = $request->all();
            $accountinquiryforms   =  $this->accountinquiryform->where('id', '<>', null);
            if (isset($input['search_per_id']) ) {

                if (isset($input['search_per_id'])) {
                    $accountinquiryforms->where('per_id', 'LIKE', '%' . $input['search_per_id'] . '%');
                }
                
            }
            $details['lists'] = $accountinquiryforms->orderBy('id', 'DESC')->paginate(50);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        try {
            $details['accountinquiryform'] = $this->accountinquiryform->where('status', 1)->get();
            $details['personalinfoform'] = $this->personalinfoform->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        try {
            // dd($request->all());
            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }


            $perinfo = $this->personalinfoform->get()->last();
            $accountinquiryform                             = new AccountInquiryForms();
            $accountinquiryform->per_id                         = $perinfo->id;
            $accountinquiryform->depositing_amount             = $request->depositing_amount;
            $accountinquiryform->depositing_amount_word        = $request->depositing_amount_word;
            $accountinquiryform->atm_card                    = $request->atm_card;
            $accountinquiryform->sms_alerts                    = $request->sms_alerts;
            $accountinquiryform->statement_email                = $request->statement_email;
            $accountinquiryform->document                      = $request->document;
            $accountinquiryform->save();



            toastr()->success('Added Successfully');
            return redirect('/master/accountinquiryform');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //    try
        //     {

        $details['detail'] = $this->accountinquiryform->whereId($id)->first();

        return view($this->view . 'edit', $details);
        // }catch(\Exception $ex)
        // {
        //     toastr()->success($ex->getMessage());
        //     return back()->with('error', $ex->getMessage());
        // }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $accountinquiryform                                 = AccountInquiryForms::find($id);
            $accountinquiryform->depositing_amount              = $request->depositing_amount;
            $accountinquiryform->depositing_amount_word         = $request->depositing_amount_word;
            $accountinquiryform->atm_card                    = $request->atm_card;
            $accountinquiryform->sms_alerts                    = $request->sms_alerts;
            $accountinquiryform->statement_email                = $request->statement_email;
            $accountinquiryform->document                    = $request->document;
            $accountinquiryform->save();


            toastr()->success('Update Successfully');
            return redirect('/master/accountinquiryform');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->accountinquiryform::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/accountinquiryform');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $accountinquiryforms = $this->accountinquiryform->whereId($request->id)->first();

        if ($accountinquiryforms->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->accountinquiryform->whereId($request->id)->update($data);
        $accountinquiryforms = $this->accountinquiryform->whereId($request->id)->first();
        $message = $accountinquiryforms->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/accountinquiryform');
    }
}
