<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Awards;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AwardController extends Controller
{

     #Bind view
     protected $view = 'admin.master.award.';


     #Bind Award model
     protected $award;

     public function __construct(
                        
        Awards $award

                        )
     {
        $this->award               = $award;
     } 



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {

             $input = $request->all();
             $awards = $this->award->where('created_at','<>',null);
            if(isset($input['search_name']) || isset($input['search_status'])){

                if(isset($input['search_name']) ){
                    $ $awards->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                     $awards->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =  $awards->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['award'] = $this->award->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         try{
            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $award                 = new Awards();
            $award->image           =isset($request->image) ? fileUpload('public/admin/master/award', $request->file('image')) : '';
            
            $award->save();
              toastr()->success('Added Successfully');
            return redirect('/master/award');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Awards  $award
     * @return \Illuminate\Http\Response
     */
    public function show(Awards $award)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Awards  $award
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->award->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Awards  $award
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [
                

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $award =  Awards::find($id);
            if(isset($request->image))
            $award->image           =isset($request->image) ? fileUpload('public/admin/master/award', $request->file('image')) : '';
            
            $award->save();
             toastr()->success('Update Successfully');
            return redirect('/master/award');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->award::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/award');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $awards = $this->award->whereId($request->id)->first();

        if($awards->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->award->whereId($request->id)->update($data);
          $awards = $this->award->whereId($request->id)->first();
          $message = $awards->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/award');
    }
}
