<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Banner;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class BannerController extends Controller
{

    #Bind view
    protected $view = 'admin.master.banner.';


    #Bind Banner model
    protected $banner;

    public function __construct(

        Banner $banner

    ) {
        $this->banner               = $banner;
    }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {

            $input = $request->all();
            $banners = $this->banner->where('created_at', '<>', null);
            if (isset($input['search_name'])) {

                if (isset($input['search_name'])) {
                    $banners->where('name', 'LIKE', '%' . $input['search_name'] . '%');
                }
            }
            $details['lists'] =  $banners->orderBy('id', 'DESC')->paginate(10);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try {
            $details['banner'] = $this->banner->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        try {


            $validate = Validator::make($request->all(), [
                'name' => 'required',

            ]);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $banner                 = new Banner();
            $banner->name           = $request->name;
            $banner->type           = $request->type;
            $banner->url            = isset($request->url) ? fileUpload('public/admin/home/banner', $request->file('url')) : '';;
            $banner->save();
            toastr()->success('Added Successfully');
            return redirect('/master/banner');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function show(Banner $banner)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {

            $details['detail'] = $this->banner->whereId($id)->first();

            #render view
            return view($this->view . 'edit', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), [
                'name' => 'required',

            ]);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $banner =  Banner::find($id);
            $banner->name = $request->name;
            $banner->type = $request->type;
            if (isset($request->url))
                $banner->url            = isset($request->url) ? fileUpload('public/admin/home/banner', $request->file('url')) : '';
            $banner->save();
            toastr()->success('Update Successfully');
            return redirect('/master/banner');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->banner::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/banner');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $banners = $this->banner->whereId($request->id)->first();

        if ($banners->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->banner->whereId($request->id)->update($data);
        $banners = $this->banner->whereId($request->id)->first();
        $message = $banners->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/banner');
    }
}
