<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\ChairmanImages;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ChairmanImageController extends Controller
{

    #Bind view
    protected $view = 'admin.master.chairmanimage.';


    #Bind chairmanimage model
    protected $chairmanimage;

    public function __construct(

        ChairmanImages $chairmanimage

    ) {
        $this->chairmanimage               = $chairmanimage;
    }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {

            $input = $request->all();
            $chairmanimages = $this->chairmanimage->where('created_at', '<>', null);
            if (isset($input['search_name'])) {

                if (isset($input['search_name'])) {
                    $chairmanimages->where('name', 'LIKE', '%' . $input['search_name'] . '%');
                }
            }
            $details['lists'] =  $chairmanimages->orderBy('id', 'DESC')->paginate(10);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try {
            $details['chairmanimage'] = $this->chairmanimage->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        try {


            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $chairmanimage                 = new ChairmanImages();
            $chairmanimage->image           = isset($request->image) ? fileUpload('public/admin/master/chairmanimage', $request->file('image')) : '';
            $chairmanimage->name           = $request->name;
            $chairmanimage->post           = $request->post;
            $chairmanimage->save();
            toastr()->success('Added Successfully');
            return redirect('/master/chairmanimage');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\chairmanimages  $chairmanimage
     * @return \Illuminate\Http\Response
     */
    public function show(chairmanimages $chairmanimage)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\chairmanimages  $chairmanimage
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {

            $details['detail'] = $this->chairmanimage->whereId($id)->first();

            #render view
            return view($this->view . 'edit', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\chairmanimages  $chairmanimage
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $chairmanimage =                ChairmanImages::find($id);
            if (isset($request->image))
                $chairmanimage->image           = isset($request->image) ? fileUpload('public/admin/master/chairmanimage', $request->file('image')) : '';
            $chairmanimage->name            = $request->name;
            $chairmanimage->post           = $request->post;
            $chairmanimage->save();
            toastr()->success('Update Successfully');
            return redirect('/master/chairmanimage');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->chairmanimage::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/chairmanimage');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $chairmanimages = $this->chairmanimage->whereId($request->id)->first();

        if ($chairmanimages->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->chairmanimage->whereId($request->id)->update($data);
        $chairmanimages = $this->chairmanimage->whereId($request->id)->first();
        $message = $chairmanimages->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/chairmanimage');
    }
}
