<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Charity;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;


class CharitiesController extends Controller
{
     protected $view = 'admin.master.charities.';


     #Bind year model
     protected $Charities;


     public function __construct(
                        
                        Charity $charity
                        
                        
                       

                        )
     {
        $this->charity                   = $charity;
        
      }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {    
             $input = $request->all();
             $charitys  =  $this->charity->where('id','<>',null);
             if(isset($input['search_name']) || isset($input['search_status'])){

                if(isset($input['search_name']) ){
                    $charitys->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                    $charitys->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] = $charitys->orderBy('id', 'DESC')->paginate(50);
             
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             
             $details['charity'] = $this->charity->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $eventv                             = new Charity(); 
            $eventv->name                       = $request->name ;
            $eventv->location                   = $request->location ; 
            $eventv->image                      = isset($request->image) ? fileUpload('public/admin/home/charty',$request->file('image')): '';
            $eventv->description                = $request->description;
            $eventv->target_amount              = $request->target_amount;
            $eventv->save();

            
            
             toastr()->success('Added Successfully');
            return redirect('/donat/charities');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try
        {
            
            $details['detail'] = $this->charity->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [
                

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $eventv                             = Charity::find($id);
            $eventv->name                       = $request->name ;
            $eventv->location                   = $request->location ; 
            $eventv->image                      = isset($request->image) ? fileUpload('public/admin/home/charty',$request->file('image')): '';
            $eventv->description                = $request->description;
            $eventv->target_amount              = $request->target_amount;
            $eventv->save();

            
           

             toastr()->success('Added Successfully');
            return redirect('/donat/charities');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->charity::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('donat/charities');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $charitys = $this->charity->whereId($request->id)->first();

        if($charitys->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->charity->whereId($request->id)->update($data);
          $charitys = $this->charity->whereId($request->id)->first();
          $message = $charitys->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('donat/charities');
    }
}