<?php

namespace App\Http\Controllers\Admin\Master;
use App\Models\Country;
use App\Models\State;
use App\Models\City;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CityController extends Controller
{
    protected $view = 'admin.master.city.';
 

     #Bind year model
     protected $city;


     public function __construct(
                        
                        Country $country,
                        State $state,
                        City $city
                       

                        )
     {
        $this->country                    = $country;
        $this->state                      = $state;
        $this->city                       = $city;

      }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try
        {    
            
             $details['lists'] = $this->city->orderBy('id', 'DESC')->paginate(50);
             
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {    
             $details['city'] = $this->city->where('status',1)->get();
             $details['state'] = $this->state->where('status',1)->get();
             $details['country'] = $this->country->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       try{

            

            $validate = Validator::make($request->all(), [
                    'name' => 'required',
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $city                 = new City();
            $city->country_id        = $request->country_id ;
            $city->state_id        = $request->state_id ;
            $city->name           = $request->name;
            
            $city->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/city');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try
        {
            
            $details['detail'] = $this->city->whereId($id)->first();
            $details['country'] = $this->country->where('status',1)->get();
            $details['state'] = $this->state->where('status',1)->get();
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{

            $validate = Validator::make($request->all(), [
                'name' => 'required',

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $city                 =City::find($id);
            $city->country_id     = $request->country_id ;
            $city->state_id        = $request->state_id ;
            $city->name           = $request->name;
            
            $city->save();
           

             toastr()->success('Added Successfully');
            return redirect('/master/city');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->city::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/city');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $citys = $this->city->whereId($request->id)->first();

        if($citys->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->city->whereId($request->id)->update($data);
          $citys = $this->city->whereId($request->id)->first();
          $message = $citys->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/city');
    }
}
