<?php

namespace App\Http\Controllers\Admin\Master;
use App\Models\Country;
use App\Models\State;
use App\Models\City;
use App\Models\ContactInfo;
use App\Models\Event;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
class ContactInfoController extends Controller
{
    protected $view = 'admin.master.contactinfo.';


     #Bind year model
     protected $contactinfo;


     public function __construct(
                        
                        ContactInfo $contactinfo,
                        Country $country,
                        Event $event,
                        State $state,
                        City $city
                       

                        )
     {
        $this->contactinfo                = $contactinfo;
        $this->country                    = $country;
        $this->state                      = $state;
        $this->city                       = $city;
        $this->event                      = $event;
        
      }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       try
        {    
             
             $details['lists'] = $this->contactinfo->orderBy('id', 'DESC')->paginate(50);
             
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {   
             $details['event'] = $this->event->where('status',1)->get();
             $details['city'] = $this->city->where('status',1)->get();
             $details['state'] = $this->state->where('status',1)->get();
             $details['country'] = $this->country->where('status',1)->get();
             $details['contactinfo'] = $this->contactinfo->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

       try{

            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $contact                             = new ContactInfo(); 
            $contact->personal_info_id           = $request->personal_info_id ;
            $contact->country_id                 = $request->country_id ;
            $contact->state_id                   = $request->state_id;
            $contact->city_id                    = $request->city_id;
            $contact->email                      = $request->email;
            $contact->phone                      = $request->phone;
            $contact->address                    = $request->address;
            
            
            $contact->save();
     
              toastr()->success('Added Successfully');
             return back()->with('success', "Added Successfully");
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try
        {
            $details['city'] = $this->city->where('status',1)->get();
            $details['state'] = $this->state->where('status',1)->get();
            $details['country'] = $this->country->where('status',1)->get();
            $details['detail'] = $this->contactinfo->whereId($id)->first();
            $details['event'] = $this->event->where('status',1)->get();
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [
               
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $contact                             = ContactInfo::find($id);
            $contact->personal_info_id           = $request->personal_info_id ;
            $contact->country_id                 = $request->country_id ;
            $contact->state_id                   = $request->state_id;
            $contact->city_id                    = $request->city_id;
            $contact->email                      = $request->email;
            $contact->phone                      = $request->phone;
            $contact->address                    = $request->address;
            $contact->save();
            
        
            
             toastr()->success('Added Successfully');
             return back()->with('success', "Added Successfully");
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->contactinfo::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/contactinfo');
    }
    public function stateWiseCity(Request $request){
         $details['city'] = $this->city->where('state_id',$request->state_id)->where('status',1)->get();
          #render view
        return view($this->view.'option',$details);
    }

           
          
}
