<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\ContactUs;


# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
class ContactUsController extends Controller
{   

    protected $view = 'admin.master.contactus.';

    #Bind contactus model
     protected $contactus;


     public function __construct(
                        
                        ContactUs $contactus

                        )
     {
        $this->contactus          = $contactus;
      

      }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
         try
        {
             $input = $request->all();
             $contactuss = $this->contactus->where('id','<>',null);
             if(isset($input['search_name']) || isset($input['search_status'])){

                if(isset($input['search_name']) ){
                    $contactuss->where('f_name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                    $contactuss->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =$contactuss->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['contactus'] = $this->contactus->where('status',1)->get();
            
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $personalinfo                      = new PersonalInfo(); 
            $personalinfo->image               = isset($request->image) ? fileUpload('public/admin/home/personalinfo',$request->file('image')): '';
            $personalinfo->gender              = $request->gender;
            $personalinfo->register_for        = $request->register_for;
            $personalinfo->canditate_name      = $request->canditate_name;
            $personalinfo->dob                 = $request->dob;
            $personalinfo->birth_place         = $request->birth_place;
            $personalinfo->height              = $request->height;
            $personalinfo->caste               = $request->caste;
            $personalinfo->sub_caste           = $request->sub_caste;
            $personalinfo->education           = $request->education;
            $personalinfo->farm_area           = $request->farm_area;
            $personalinfo->occupation          = $request->occupation;
            $personalinfo->a_income            = $request->a_income;
            $personalinfo->rashi               = $request->rashi;
            $personalinfo->blood_group         = $request->blood_group;
            $personalinfo->save();
             toastr()->success('Added Successfully');
            return redirect('/master/contactus');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->contactus->whereId($id)->first();
            
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{

            $validate = Validator::make($request->all(), [
               
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $contactusl                   = ContactUs::find($id);
            $contactusl->f_name           = $request->f_name ;
            $contactusl->l_name           = $request->l_name ;
            $contactusl->email_id         = $request->email_id;
            $contactusl->mobile           = $request->mobile;
            $contactusl->message          = $request->message;
            $contactusl->save();
        
            
             toastr()->success('Added Successfully');
            return redirect('/master/contactus');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $caste = $this->contactus::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/contactus');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $contactuss = $this->contactus->whereId($request->id)->first();

        if($contactuss->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->contactus->whereId($request->id)->update($data);
          $contactuss = $this->contactus->whereId($request->id)->first();
          $message = $contactuss->status ==1? 'Active' : 'InActive';
       toastr()->success('You are successfully '.$message);
       return redirect('master/contactus');
    }
}
