<?php

namespace App\Http\Controllers\Admin\Master;
use App\Models\Country;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CountryController extends Controller
{
    #Bind view
     protected $view = 'admin.master.country.';


     #Bind country model
     protected $country;

     public function __construct(
                        
                        Country $country

                        )
     {
        $this->country               = $country;
     } 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
          try
        { 
             $input = $request->all();
             $countrys   =  $this->country->where('id','<>',null);
              if(isset($input['search_name']) || isset($input['search_status'])){

                if(isset($input['search_name']) ){
                    $countrys->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                    $countrys->where('status', $input['search_status']);
                }
                 
               
            } 
            $details['lists'] = $countrys->orderBy('id', 'DESC')->paginate(50);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {    
             $details['country'] = $this->country->where('status',1)->get();
             
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $country                             = new Country(); 
            $country->name                       = $request->name ;
    
            $country->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/country');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->country->whereId($id)->first();
            
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{

            $validate = Validator::make($request->all(), [
               
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $country                         = Country::find($id);
            $country->name                   = $request->name;
            
            $country->save();
        
            
             toastr()->success('Added Successfully');
            return redirect('/master/country');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $caste = $this->country::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/country');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

         #get the detail of requested resources
        $countrys = $this->country->whereId($request->id)->first();

        if($countrys->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->country->whereId($request->id)->update($data);
          $countrys = $this->country->whereId($request->id)->first();
          $message = $countrys->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/country');
    }
}
