<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\DirectorImages;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DirectorImageController extends Controller
{

    #Bind view
    protected $view = 'admin.master.directorimage.';


    #Bind directorimage model
    protected $directorimage;

    public function __construct(

        DirectorImages $directorimage

    ) {
        $this->directorimage               = $directorimage;
    }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // return($request->all());
        try {

            $input = $request->all();
            $directorimages = $this->directorimage->where('created_at', '<>', null);
            if (isset($input['search_name'])) {

                if (isset($input['search_name'])) {
                    $directorimages->where('name', 'LIKE', '%' . $input['search_name'] . '%');
                }
            }
            $details['lists'] =  $directorimages->orderBy('id', 'DESC')->paginate(10);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try {
            $details['directorimage'] = $this->directorimage->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        try {


            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $directorimage                 = new DirectorImages();
            $directorimage->image           = isset($request->image) ? fileUpload('public/admin/master/directorimage', $request->file('image')) : '';
            $directorimage->name           = $request->name;
            $directorimage->post           = $request->post;
            $directorimage->save();
            toastr()->success('Added Successfully');
            return redirect('/master/directorimage');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\directorimages  $directorimage
     * @return \Illuminate\Http\Response
     */
    public function show(directorimages $directorimage)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\directorimages  $directorimage
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {

            $details['detail'] = $this->directorimage->whereId($id)->first();

            #render view
            return view($this->view . 'edit', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\directorimages  $directorimage
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $directorimage =                DirectorImages::find($id);
            if (isset($request->image))
                $directorimage->image           = isset($request->image) ? fileUpload('public/admin/master/directorimage', $request->file('image')) : '';
            $directorimage->name            = $request->name;
            $directorimage->post           = $request->post;
            $directorimage->save();
            toastr()->success('Update Successfully');
            return redirect('/master/directorimage');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->directorimage::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/directorimage');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $directorimages = $this->directorimage->whereId($request->id)->first();

        if ($directorimages->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->directorimage->whereId($request->id)->update($data);
        $directorimages = $this->directorimage->whereId($request->id)->first();
        $message = $directorimages->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/directorimage');
    }
}
