<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Directory;


# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DirectoryController extends Controller
{

     protected $view = 'admin.master.directory.';

     public function __construct(
                        
                        Directory $directory

                        )
     {
        $this->directory          = $directory;
      

      }








    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
         try
        {
             $input = $request->all();
             $directorys = $this->directory->where('created_at','<>',null);
             if(isset($input['search_name']) || isset($input['search_status'])){

                if(isset($input['search_name']) ){
                    $directorys->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                    $directorys->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] = $directorys->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['directory'] = $this->directory->where('status',1)->get();
            
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       try{

            

            $validate = Validator::make($request->all(), [
                    'name' => 'required',
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $directory                   = new Directory();
            $directory->name             = $request->name ;
            $directory->profession       = $request->profession ;
            $directory->email            = $request->email;
            $directory->mobile           = $request->mobile;
            $directory->location         = $request->location;
            $directory->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/directory');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try
        {
            $details['detail'] = $this->directory->whereId($id)->first();
            
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [
                'name' => 'required',

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $directoryl                   = Directory::find($id);
            $directoryl->name             = $request->name ;
            $directoryl->profession       = $request->profession ;
            $directoryl->email            = $request->email;
            $directoryl->mobile           = $request->mobile;
            $directoryl->location         = $request->location;
            $directoryl->save();
           
             toastr()->success('Added Successfully');
            return redirect('/master/directory');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->directory::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/directory');
    }

    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $directorys = $this->directory->whereId($request->id)->first();

        if($directorys->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->directory->whereId($request->id)->update($data);
          $directorys = $this->directory->whereId($request->id)->first();
          $message = $directorys->status ==0 ? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/directory');
    }
}
