<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Discreption;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DiscreptionController extends Controller
{

     #Bind view
     protected $view = 'admin.master.discreption.';


     #Bind discreption model
     protected $discreption;

     public function __construct(
                        
        Discreption $discreption

                        )
     {
        $this->discreption               = $discreption;
     } 



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {

             $input = $request->all();
             $discreptions = $this->discreption->where('created_at','<>',null);
            if(isset($input['search_name']) || isset($input['search_status'])){

                if(isset($input['search_name']) ){
                    $ $discreptions->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                     $discreptions->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =  $discreptions->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['discreption'] = $this->discreption->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         try{
            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $discreption                 = new Discreption();
            $discreption->type         = $request->type;
            $discreption->discreption         = $request->discreption;
            $discreption->save();
              toastr()->success('Added Successfully');
            return redirect('/master/discreption');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\discreption  $discreption
     * @return \Illuminate\Http\Response
     */
    public function show(discreption $discreption)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\discreption  $discreption
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->discreption->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\discreption  $discreption
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [
                

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $discreption                        =  Discreption::find($id);
            $discreption->type                  = $request->type;
            $discreption->discreption         = $request->discreption;
            $discreption->save();
             toastr()->success('Update Successfully');
            return redirect('/master/discreption');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->discreption::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/discreption');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $discreptions = $this->discreption->whereId($request->id)->first();

        if($discreptions->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->discreption->whereId($request->id)->update($data);
          $discreptions = $this->discreption->whereId($request->id)->first();
          $message = $discreptions->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/discreption');
    }
}
