<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Event;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
class EventController extends Controller
{
    protected $view = 'admin.master.event.';

     public function __construct(
                        
                        Event $event

                        )
     {
        $this->event          = $event;
      

      }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
         try
        {
             $input = $request->all();
             $events = $this->event->where('id','<>',null);
             if(isset($input['search_name']) || isset($input['search_status'])){

                if(isset($input['search_name']) ){
                    $events->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                    $events->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =  $events->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {    
             $details['event'] = $this->event->where('status',1)->get();
            
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

      try{

            

            $validate = Validator::make($request->all(), [
                    'name' => 'required',
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $eventv                      = new Event(); 
            $eventv->name                = $request->name ;
            $eventv->image               = isset($request->image) ? fileUpload('public/admin/home/event',$request->file('image')): '';
            $eventv->short_description   = $request->short_description;
            $eventv->long_description    = $request->long_description;
            $eventv->event_date          = $request->event_date;
            $eventv->start_time          = $request->start_time;
            $eventv->end_time            = $request->end_time;
            $eventv->location            = $request->location;
            $eventv->a_canditate         = $request->a_canditate;
            $eventv->e_p_c_amount        = $request->e_p_c_amount;
            $eventv->amount              = $request->amount;

            $eventv->save();
     
             toastr()->success('Added Successfully');
            return redirect('/eve/event');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
        try
        {
            $details['detail'] = $this->event->whereId($id)->first();
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)

    {


        try{

            $validate = Validator::make($request->all(), [
                'name' => 'required',

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $eventl                      = Event::find($id);
            $eventl->name                = $request->name ;
            if(isset($request->image))
            $eventl->image               = isset($request->image) ? fileUpload('public/admin/home/event',$request->file('image')): '';
            $eventl->short_description   = $request->short_description;
            $eventl->long_description    = $request->long_description;
            $eventl->event_date          = $request->event_date;
            $eventl->start_time          = $request->start_time;
            $eventl->end_time            = $request->end_time;
            $eventl->location            = $request->location;
            $eventl->a_canditate         = $request->a_canditate;
            $eventl->e_p_c_amount        = $request->e_p_c_amount;
            $eventl->amount              = $request->amount;

            $eventl->save();
     
            
             toastr()->success('Added Successfully');
            return redirect('/eve/event');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->event::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('eve/event');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $events = $this->event->whereId($request->id)->first();

        if($events->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->event->whereId($request->id)->update($data);
          $events = $this->event->whereId($request->id)->first();
          $message = $events->status ==0 ? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('eve/event');
    }
}
