<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\FacebookBanners;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FacebookBannerController extends Controller
{

     #Bind view
     protected $view = 'admin.master.facebookbanner.';


     #Bind facebookbanner model
     protected $facebookbanner;

     public function __construct(
                        
        FacebookBanners $facebookbanner

                        )
     {
        $this->facebookbanner               = $facebookbanner;
     } 



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {

             $input = $request->all();
             $facebookbanners = $this->facebookbanner->where('created_at','<>',null);
            if(isset($input['search_name']) || isset($input['search_status'])){

                if(isset($input['search_name']) ){
                    $ $facebookbanners->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                     $facebookbanners->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =  $facebookbanners->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['facebookbanner'] = $this->facebookbanner->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         try{
            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $facebookbanner                 = new FacebookBanners();
            
            $facebookbanner->image           =isset($request->image) ? fileUpload('public/admin/master/facebookbanner', $request->file('image')) : '';
            
            $facebookbanner->save();
              toastr()->success('Added Successfully');
            return redirect('/master/facebookbanner');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\facebookbanners  $facebookbanner
     * @return \Illuminate\Http\Response
     */
    public function show(facebookbanners $facebookbanner)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\facebookbanners  $facebookbanner
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->facebookbanner->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\facebookbanners  $facebookbanner
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [
                

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $facebookbanner =                FacebookBanners::find($id);
            
            if(isset($request->image))
            $facebookbanner->image           =isset($request->image) ? fileUpload('public/admin/master/facebookbanner', $request->file('image')) : '';
            
            $facebookbanner->save();
             toastr()->success('Added Successfully');
            return redirect('/master/facebookbanner');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->facebookbanner::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/facebookbanner');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $facebookbanners = $this->facebookbanner->whereId($request->id)->first();

        if($facebookbanners->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->facebookbanner->whereId($request->id)->update($data);
          $facebookbanners = $this->facebookbanner->whereId($request->id)->first();
          $message = $facebookbanners->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/facebookbanner');
    }
}
