<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Event;
use App\Models\FamilyInfo;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FamilyInfoController extends Controller
{
     protected $view = 'admin.master.familyinfo.';


     #Bind year model
     protected $familyinfo;


     public function __construct(
                        
                        Event $event,
                        FamilyInfo $familyinfo
                       

                        )
     {
        $this->event                    = $event;
        $this->familyinfo               = $familyinfo;
        

      }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
          try
        {
             $details['lists'] = $this->familyinfo->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {    
             $details['familyinfo'] = $this->familyinfo->where('status',1)->get();
             $details['event'] = $this->event->where('status',1)->get();   
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        try{

            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $family                             = new FamilyInfo(); 
            $family->personal_info_id           = $request->personal_info_id ;
            $family->f_name                     = $request->f_name ;
            $family->f_occupation               = $request->f_occupation;
            $family->m_name                     = $request->m_name;
            $family->m_occupation               = $request->m_occupation;
            $family->m_uncile                   = $request->m_uncile;
            $family->p_uncile                   = $request->p_uncile;
            $family->exception                  = $request->exception;
            
            $family->save();
     
             toastr()->success('Added Successfully');
             return back()->with('success', "Added Successfully");
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try
        {
            
            $details['detail'] = $this->familyinfo->whereId($id)->first();
            $details['event'] = $this->event->where('status',1)->get();
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{

            $validate = Validator::make($request->all(), [
               
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $family                             = FamilyInfo::find($id);
            $family->personal_info_id           = $request->personal_info_id ;
            $family->f_name                     = $request->f_name ;
            $family->f_occupation               = $request->f_occupation;
            $family->m_name                     = $request->m_name;
            $family->m_occupation               = $request->m_occupation;
            $family->m_uncile                   = $request->m_uncile;
            $family->p_uncile                   = $request->p_uncile;
            $family->exception                  = $request->exception;
            
            $family->save();
        
            
           toastr()->success('Added Successfully');
             return back()->with('success', "Added Successfully");
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
