<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Gallery;
use App\Models\Year;


# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class GalleryController extends Controller
{

     protected $view = 'admin.master.gallery.';


     #Bind year model
     protected $gallery;


     public function __construct(
                        
                        Gallery $gallery,
                        Year    $year

                        )
     {
        $this->gallery               = $gallery;
        $this->year                  = $year;

      }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {
             $input = $request->all();
             $gallery = $this->gallery->where('created_at','<>',null);
            if(isset($input['search_name']) || isset($input['search_status']) || isset($input['search_year'])){

                if(isset($input['search_name']) ){
                    $gallery->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                    $gallery->where('status', $input['search_status']);
                }
                 if(isset($input['search_year'])){
                    $gallery->where('year_id', $input['search_year']);
                }
               
            } 
            $details['lists'] =  $gallery->orderBy('id', 'DESC')->paginate(100);
             $details['year'] = $this->year->where('status',1)->get();
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['gallery'] = $this->gallery->where('status',1)->get();
             $details['year'] = $this->year->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        

       try{

            

            $validate = Validator::make($request->all(), [
                    'name' => 'required',
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $galleryl                 = new Gallery();
            $galleryl->year_id        = $request->year_id ;
            $galleryl->name           = $request->name;
            $galleryl->url            = isset($request->url) ? fileUpload('public/admin/home/gallery',$request->file('url')): '';
            $galleryl->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/gallery');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function show(Gallery $gallery)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->gallery->whereId($id)->first();
            $details['year'] = $this->year->where('status',1)->get();
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

         try{

            $validate = Validator::make($request->all(), [
                'name' => 'required',

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $galleryl                 = Gallery::find($id);
            $galleryl->year_id       = $request->year_id ;
            $galleryl->name           = $request->name;
            $galleryl->url            = isset($request->url) ? fileUpload('public/admin/home/gallery',$request->file('url')): '';
            $galleryl->save();
             toastr()->success('Added Successfully');
            return redirect('/master/gallery');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $caste = $this->gallery::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/gallery');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $gallerys = $this->gallery->whereId($request->id)->first();

        if($gallerys->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->gallery->whereId($request->id)->update($data);
          $gallerys = $this->gallery->whereId($request->id)->first();
          $message = $gallerys->status ==1? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/gallery');
    }
}
