<?php

namespace App\Http\Controllers\Admin\Master;
use App\Models\InquiryForms;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class InquiryFormController extends Controller
{
    #Bind view
     protected $view = 'admin.master.inquiryform.';


     #Bind inquiryform model
     protected $inquiryform;

     public function __construct(
                        
        InquiryForms $inquiryform

                        )
     {
        $this->inquiryform               = $inquiryform;
     } 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function index(Request $request)
    {
          try
        { 
             $input = $request->all();
             $inquiryforms   =  $this->inquiryform->where('id','<>',null);
              if(isset($input['search_fname'])){

                if(isset($input['search_fname']) ){
                    $inquiryforms->where('fname','LIKE','%'.$input['search_fname'].'%');
                }
                 
               
            } 
            $details['lists'] = $inquiryforms->orderBy('id', 'DESC')->paginate(50);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {    
             $details['inquiryform'] = $this->inquiryform->where('status',1)->get();
             
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            

            $validate = Validator::make($request->all(), [
                'fname' => 'required',
                'lname' => 'required',
                'monumber' => 'required',
                'email' => 'required|email',
                'message' => 'required'
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $inquiryform                             = new InquiryForms(); 
            $inquiryform->fname                    = $request->fname ;
            $inquiryform->lname                = $request->lname ;
            $inquiryform->monumber               = $request->monumber ;
            $inquiryform->email                = $request->email ;
            $inquiryform->message               = $request->message ;
            $inquiryform->type               = $request->type ;
            $inquiryform->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/inquiryform');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->inquiryform->whereId($id)->first();
            
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{

            $validate = Validator::make($request->all(), [
                
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $inquiryform                         = InquiryForms::find($id);
            $inquiryform->fname                    = $request->fname ;
            $inquiryform->lname                = $request->lname ;
            $inquiryform->monumber               = $request->monumber ;
            $inquiryform->email                = $request->email ;
            $inquiryform->message               = $request->message ;
            $inquiryform->type               = $request->type ;
            $inquiryform->save();
        
            
             toastr()->success('Update Successfully');
            return redirect('/master/inquiryform');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $caste = $this->inquiryform::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/inquiryform');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

         #get the detail of requested resources
        $inquiryforms = $this->inquiryform->whereId($request->id)->first();

        if($inquiryforms->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->inquiryform->whereId($request->id)->update($data);
          $inquiryforms = $this->inquiryform->whereId($request->id)->first();
          $message = $inquiryforms->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/inquiryform');
    }
}
