<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\IntroducerForms;
use App\Models\PersonalInfoForms;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class IntroducerFormController extends Controller
{
    #Bind view
    protected $view = 'admin.master.introducerform.';


    #Bind introducerform model
    protected $introducerform;

    public function __construct(

        IntroducerForms $introducerform,
        PersonalInfoForms $personalinfoform

    ) {
        $this->introducerform                = $introducerform;
        $this->personalinfoform                = $personalinfoform;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        try {
            $input = $request->all();
            $introducerforms   =  $this->introducerform->where('id', '<>', null);
            if (isset($input['search_fname']) ) {

                if (isset($input['search_fname'])) {
                    $introducerforms->where('fname', 'LIKE', '%' . $input['search_fname'] . '%');
                }
            }
            $details['lists'] = $introducerforms->orderBy('id', 'DESC')->paginate(50);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        try {
            $details['introducerform'] = $this->introducerform->where('status', 1)->get();
            $details['personalinfoform'] = $this->personalinfoform->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {



            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $perinfo = $this->personalinfoform->get()->last();
            $introducerform                                 = new IntroducerForms();
            $introducerform->per_id                         = $perinfo->id;
            $introducerform->salutat                   = $request->salutat;
            $introducerform->fname                          = $request->fname;
            $introducerform->mname                          = $request->mname;
            $introducerform->lname                               = $request->lname;

            $introducerform->accounttype1                    = $request->accounttype1;
            $introducerform->introducer_account_number                = $request->introducer_account_number;
            $introducerform->known_account_holder_since               = $request->known_account_holder_since;

            $introducerform->address                         = $request->address;
            $introducerform->city                             = $request->city;
            $introducerform->taluka                          = $request->taluka;
            $introducerform->district                        = $request->district;
            $introducerform->pin                             = $request->pin;
            $introducerform->state                            = $request->state;
            $introducerform->save();

            toastr()->success('Added Successfully');
            return redirect('/master/introducerform');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //    try
        //     {




        $details['detail'] = $this->introducerform->whereId($id)->first();

        return view($this->view . 'edit', $details);
        // }catch(\Exception $ex)
        // {
        //     toastr()->success($ex->getMessage());
        //     return back()->with('error', $ex->getMessage());
        // }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $introducerform                         = IntroducerForms::find($id);
            $introducerform->salutat                = $request->salutat;
            $introducerform->fname                    = $request->fname;
            $introducerform->mname                = $request->mname;
            $introducerform->lname                    = $request->lname;

            $introducerform->accounttype1                    = $request->accounttype1;
            $introducerform->introducer_account_number                = $request->introducer_account_number;
            $introducerform->known_account_holder_since               = $request->known_account_holder_since;

            $introducerform->address        = $request->address;
            $introducerform->city                = $request->city;
            $introducerform->taluka                    = $request->taluka;
            $introducerform->district                = $request->district;
            $introducerform->pin                    = $request->pin;
            $introducerform->state                = $request->state;
            $introducerform->save();


            toastr()->success('Update Successfully');
            return redirect('/master/introducerform');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->introducerform::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/introducerform');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $introducerforms = $this->introducerform->whereId($request->id)->first();

        if ($introducerforms->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->introducerform->whereId($request->id)->update($data);
        $introducerforms = $this->introducerform->whereId($request->id)->first();
        $message = $introducerforms->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/introducerform');
    }
}
