<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Investment1;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class Investment1Controller extends Controller
{

     #Bind view
     protected $view = 'admin.master.investment1.';


     #Bind investment1 model
     protected $investment1;

     public function __construct(
                        
        Investment1 $investment1

                        )
     {
        $this->investment1               = $investment1;
     } 



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {

             $input = $request->all();
             $investment1s = $this->investment1->where('created_at','<>',null);
            if(isset($input['search_investment1']) || isset($input['search_status'])){

                if(isset($input['search_investment1']) ){
                     $investment1s->where('investment1','LIKE','%'.$input['search_investment1'].'%');
                }
                if(isset($input['search_status'])){
                     $investment1s->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =  $investment1s->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['investment1'] = $this->investment1->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         try{
            

            $validate = Validator::make($request->all(), [
                
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $investment1                 = new Investment1();
            $investment1->interest_payout           = $request->interest_payout;
            $investment1->redemption           = $request->redemption;
            $investment1->description           = $request->description;
            $investment1->save();
              toastr()->success('Added Successfully');
            return redirect('/master/investment1');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\investment1s  $investment1
     * @return \Illuminate\Http\Response
     */
    public function show(investment1s $investment1)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\investment1s  $investment1
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->investment1->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\investment1s  $investment1
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $investment1                 =  Investment1::find($id);
            $investment1->interest_payout           = $request->interest_payout;
            $investment1->redemption           = $request->redemption;
            $investment1->description           = $request->description;
            $investment1->save();
             toastr()->success('Update Successfully');
            return redirect('/master/investment1');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->investment1::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/investment1');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $investment1s = $this->investment1->whereId($request->id)->first();

        if($investment1s->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->investment1->whereId($request->id)->update($data);
          $investment1s = $this->investment1->whereId($request->id)->first();
          $message = $investment1s->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/investment1');
    }
}
