<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Investment3;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class Investment3Controller extends Controller
{

     #Bind view
     protected $view = 'admin.master.investment3.';


     #Bind investment3 model
     protected $investment3;

     public function __construct(
                        
        Investment3 $investment3

                        )
     {
        $this->investment3               = $investment3;
     } 



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {

             $input = $request->all();
             $investment3s = $this->investment3->where('created_at','<>',null);
            if(isset($input['search_investment3']) || isset($input['search_status'])){

                if(isset($input['search_investment3']) ){
                     $investment3s->where('investment3','LIKE','%'.$input['search_investment3'].'%');
                }
                if(isset($input['search_status'])){
                     $investment3s->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =  $investment3s->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['investment3'] = $this->investment3->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         try{
            

            $validate = Validator::make($request->all(), [
                
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $investment3                 = new Investment3();
            $investment3->interest_payout           = $request->interest_payout;
            $investment3->redemption           = $request->redemption;
            $investment3->description           = $request->description;
            $investment3->save();
              toastr()->success('Added Successfully');
            return redirect('/master/investment3');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\investment3s  $investment3
     * @return \Illuminate\Http\Response
     */
    public function show(investment3s $investment3)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\investment3s  $investment3
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->investment3->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\investment3s  $investment3
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $investment3                 =  Investment3::find($id);
            $investment3->interest_payout           = $request->interest_payout;
            $investment3->redemption           = $request->redemption;
            $investment3->description           = $request->description;
            $investment3->save();
             toastr()->success('Update Successfully');
            return redirect('/master/investment3');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->investment3::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/investment3');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $investment3s = $this->investment3->whereId($request->id)->first();

        if($investment3s->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->investment3->whereId($request->id)->update($data);
          $investment3s = $this->investment3->whereId($request->id)->first();
          $message = $investment3s->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/investment3');
    }
}
