<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Investment4;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class Investment4Controller extends Controller
{

     #Bind view
     protected $view = 'admin.master.investment4.';


     #Bind investment4 model
     protected $investment4;

     public function __construct(
                        
        Investment4 $investment4

                        )
     {
        $this->investment4               = $investment4;
     } 



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {

             $input = $request->all();
             $investment4s = $this->investment4->where('created_at','<>',null);
            if(isset($input['search_investment4']) || isset($input['search_status'])){

                if(isset($input['search_investment4']) ){
                     $investment4s->where('investment4','LIKE','%'.$input['search_investment4'].'%');
                }
                if(isset($input['search_status'])){
                     $investment4s->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =  $investment4s->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['investment4'] = $this->investment4->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         try{
            

            $validate = Validator::make($request->all(), [
                
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $investment4                 = new Investment4();
            $investment4->interest_payout           = $request->interest_payout;
            $investment4->min_amount           = $request->min_amount;
            $investment4->min_time           = $request->min_time;
            $investment4->pre_maturity           = $request->pre_maturity;
            $investment4->save();
              toastr()->success('Added Successfully');
            return redirect('/master/investment4');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\investment4s  $investment4
     * @return \Illuminate\Http\Response
     */
    public function show(investment4s $investment4)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\investment4s  $investment4
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->investment4->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\investment4s  $investment4
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $investment4                 =  Investment4::find($id);
            $investment4->interest_payout           = $request->interest_payout;
            $investment4->min_amount           = $request->min_amount;
            $investment4->min_time           = $request->min_time;
            $investment4->pre_maturity           = $request->pre_maturity;
            $investment4->save();
             toastr()->success('Update Successfully');
            return redirect('/master/investment4');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->investment4::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/investment4');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $investment4s = $this->investment4->whereId($request->id)->first();

        if($investment4s->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->investment4->whereId($request->id)->update($data);
          $investment4s = $this->investment4->whereId($request->id)->first();
          $message = $investment4s->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/investment4');
    }
}
