<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Investment5;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class Investment5Controller extends Controller
{

     #Bind view
     protected $view = 'admin.master.investment5.';


     #Bind investment5 model
     protected $investment5;

     public function __construct(
                        
        Investment5 $investment5

                        )
     {
        $this->investment5               = $investment5;
     } 



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {

             $input = $request->all();
             $investment5s = $this->investment5->where('created_at','<>',null);
            if(isset($input['search_investment5']) || isset($input['search_status'])){

                if(isset($input['search_investment5']) ){
                     $investment5s->where('investment5','LIKE','%'.$input['search_investment5'].'%');
                }
                if(isset($input['search_status'])){
                     $investment5s->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =  $investment5s->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['investment5'] = $this->investment5->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         try{
            

            $validate = Validator::make($request->all(), [
                
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $investment5                 = new Investment5();
            $investment5->interest_payout           = $request->interest_payout;
            $investment5->rule           = $request->rule;
            $investment5->save();
              toastr()->success('Added Successfully');
            return redirect('/master/investment5');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\investment5s  $investment5
     * @return \Illuminate\Http\Response
     */
    public function show(investment5s $investment5)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\investment5s  $investment5
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->investment5->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\investment5s  $investment5
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $investment5                 =  Investment5::find($id);
            $investment5->interest_payout           = $request->interest_payout;
            $investment5->rule           = $request->rule;
            $investment5->save();
             toastr()->success('Update Successfully');
            return redirect('/master/investment5');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->investment5::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/investment5');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $investment5s = $this->investment5->whereId($request->id)->first();

        if($investment5s->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->investment5->whereId($request->id)->update($data);
          $investment5s = $this->investment5->whereId($request->id)->first();
          $message = $investment5s->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/investment5');
    }
}
