<?php

namespace App\Http\Controllers\Admin\Master;
use App\Models\MaritalStatus;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class MaritalStatusController extends Controller
{
    #Bind view
     protected $view = 'admin.master.maritalstatus.';


     #Bind maritalstatus model
     protected $maritalstatus;

     public function __construct(
                        
        MaritalStatus $maritalstatus

                        )
     {
        $this->maritalstatus               = $maritalstatus;
     } 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function index(Request $request)
    {
          try
        { 
             $input = $request->all();
             $maritalstatuss   =  $this->maritalstatus->where('id','<>',null);
              if(isset($input['search_maritalstatus']) || isset($input['search_status'])){

                if(isset($input['search_maritalstatus']) ){
                    $maritalstatuss->where('maritalstatus','LIKE','%'.$input['search_maritalstatus'].'%');
                }
                if(isset($input['search_status'])){
                    $maritalstatuss->where('status', $input['search_status']);
                }
                 
               
            } 
            $details['lists'] = $maritalstatuss->orderBy('id', 'DESC')->paginate(50);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {    
             $details['maritalstatus'] = $this->maritalstatus->where('status',1)->get();
             
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $maritalstatus                             = new MaritalStatus(); 
            $maritalstatus->maritalstatus                    = $request->maritalstatus ;
            $maritalstatus->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/maritalstatus');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->maritalstatus->whereId($id)->first();
            
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{

            $validate = Validator::make($request->all(), [
               
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $maritalstatus                         = MaritalStatus::find($id);
            $maritalstatus->maritalstatus                    = $request->maritalstatus ;
            $maritalstatus->save();
        
            
             toastr()->success('Added Successfully');
            return redirect('/master/maritalstatus');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $caste = $this->maritalstatus::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/maritalstatus');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

         #get the detail of requested resources
        $maritalstatuss = $this->maritalstatus->whereId($request->id)->first();

        if($maritalstatuss->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->maritalstatus->whereId($request->id)->update($data);
          $maritalstatuss = $this->maritalstatus->whereId($request->id)->first();
          $message = $maritalstatuss->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/maritalstatus');
    }
}
