<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\NominationForms;
use App\Models\PersonalInfoForms;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class NominationFormController extends Controller
{
    #Bind view
    protected $view = 'admin.master.nominationform.';


    #Bind nominationform model
    protected $nominationform;

    public function __construct(

        NominationForms $nominationform,
        PersonalInfoForms $personalinfoform

    ) {
        $this->nominationform               = $nominationform;
        $this->personalinfoform                = $personalinfoform;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        try {
            $input = $request->all();
            $nominationforms   =  $this->nominationform->where('id', '<>', null);
            if (isset($input['search_fname']) ) {

                if (isset($input['search_fname'])) {
                    $nominationforms->where('fname', 'LIKE', '%' . $input['search_fname'] . '%');
                }
               
            }
            $details['lists'] = $nominationforms->orderBy('id', 'DESC')->paginate(50);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        try {
            $details['nominationform'] = $this->nominationform->where('status', 1)->get();
            $details['personalinfoform'] = $this->personalinfoform->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {



            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $perinfo = $this->personalinfoform->get()->last();
            $nominationform                             = new NominationForms();
            $nominationform->per_id                         = $perinfo->id;
            $nominationform->saluta                = $request->saluta;
            $nominationform->fname             = $request->fname;
            $nominationform->mname        = $request->mname;
            $nominationform->lname                    = $request->lname;
            $nominationform->relationship                    = $request->relationship;
            $nominationform->date_of_birth                = $request->date_of_birth;
            $nominationform->nominee_minor                      = $request->nominee_minor;
            $nominationform->residential_address             = $request->residential_address;
            $nominationform->residential_city        = $request->residential_city;
            $nominationform->residential_taluka                    = $request->residential_taluka;
            $nominationform->residential_district                    = $request->residential_district;
            $nominationform->residential_pin                = $request->residential_pin;
            $nominationform->residential_state                      = $request->residential_state;
            $nominationform->permanent_address             = $request->permanent_address;
            $nominationform->permanent_city        = $request->permanent_city;
            $nominationform->permanent_taluka                    = $request->permanent_taluka;
            $nominationform->permanent_district                    = $request->permanent_district;
            $nominationform->permanent_pin                = $request->permanent_pin;
            $nominationform->permanent_state                      = $request->permanent_state;


            $nominationform->saluta2                          = $request->saluta2;
            $nominationform->guardian_fname                              = $request->guardian_fname;
            $nominationform->guardian_mname                             = $request->guardian_mname;
            $nominationform->guardian_lname                             = $request->guardian_lname;
            $nominationform->guardian_date_of_birth                    = $request->guardian_date_of_birth;
            $nominationform->guardian_residential_address                = $request->guardian_residential_address;
            $nominationform->guardian_residential_city                      = $request->guardian_residential_city;
            $nominationform->guardian_residential_taluka                 = $request->guardian_residential_taluka;
            $nominationform->guardian_residential_district                  = $request->guardian_residential_district;
            $nominationform->guardian_residential_pin                    = $request->guardian_residential_pin;
            $nominationform->guardian_residential_state                    = $request->guardian_residential_state;
            $nominationform->guardian_permanent_address                = $request->guardian_permanent_address;
            $nominationform->guardian_permanent_city                      = $request->guardian_permanent_city;
            $nominationform->guardian_permanent_taluka             = $request->guardian_permanent_taluka;
            $nominationform->guardian_permanent_district        = $request->guardian_permanent_district;
            $nominationform->guardian_permanent_pin                    = $request->guardian_permanent_pin;
            $nominationform->guardian_permanent_state                    = $request->guardian_permanent_state;
            $nominationform->save();

            toastr()->success('Added Successfully');
            return redirect('/master/nominationform');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //    try
        //     {

        $details['detail'] = $this->nominationform->whereId($id)->first();

        return view($this->view . 'edit', $details);
        // }catch(\Exception $ex)
        // {
        //     toastr()->success($ex->getMessage());
        //     return back()->with('error', $ex->getMessage());
        // }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $nominationform                                 = NominationForms::find($id);
            $nominationform->saluta                = $request->saluta;
            $nominationform->fname                              = $request->fname;
            $nominationform->mname                              = $request->mname;
            $nominationform->lname                              = $request->lname;
            $nominationform->relationship                    = $request->relationship;
            $nominationform->date_of_birth                       = $request->date_of_birth;
            $nominationform->nominee_minor                      = $request->nominee_minor;
            $nominationform->residential_address             = $request->residential_address;
            $nominationform->residential_city                    = $request->residential_city;
            $nominationform->residential_taluka                    = $request->residential_taluka;
            $nominationform->residential_district                    = $request->residential_district;
            $nominationform->residential_pin                      = $request->residential_pin;
            $nominationform->residential_state                      = $request->residential_state;
            $nominationform->permanent_address                   = $request->permanent_address;
            $nominationform->permanent_city                     = $request->permanent_city;
            $nominationform->permanent_taluka                    = $request->permanent_taluka;
            $nominationform->permanent_district                    = $request->permanent_district;
            $nominationform->permanent_pin                       = $request->permanent_pin;
            $nominationform->permanent_state                      = $request->permanent_state;


            $nominationform->saluta2                           = $request->saluta2;
            $nominationform->guardian_fname                              = $request->guardian_fname;
            $nominationform->guardian_mname                             = $request->guardian_mname;
            $nominationform->guardian_lname                             = $request->guardian_lname;
            $nominationform->guardian_date_of_birth                    = $request->guardian_date_of_birth;
            $nominationform->guardian_residential_address                = $request->guardian_residential_address;
            $nominationform->guardian_residential_city                      = $request->guardian_residential_city;
            $nominationform->guardian_residential_taluka                 = $request->guardian_residential_taluka;
            $nominationform->guardian_residential_district                  = $request->guardian_residential_district;
            $nominationform->guardian_residential_pin                    = $request->guardian_residential_pin;
            $nominationform->guardian_residential_state                    = $request->guardian_residential_state;
            $nominationform->guardian_permanent_address                = $request->guardian_permanent_address;
            $nominationform->guardian_permanent_city                      = $request->guardian_permanent_city;
            $nominationform->guardian_permanent_taluka                   = $request->guardian_permanent_taluka;
            $nominationform->guardian_permanent_district                    = $request->guardian_permanent_district;
            $nominationform->guardian_permanent_pin                    = $request->guardian_permanent_pin;
            $nominationform->guardian_permanent_state                    = $request->guardian_permanent_state;
            $nominationform->save();


            toastr()->success('Update Successfully');
            return redirect('/master/nominationform');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->nominationform::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/nominationform');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $nominationforms = $this->nominationform->whereId($request->id)->first();

        if ($nominationforms->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->nominationform->whereId($request->id)->update($data);
        $nominationforms = $this->nominationform->whereId($request->id)->first();
        $message = $nominationforms->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/nominationform');
    }
}
