<?php

namespace App\Http\Controllers\Admin\Master;
use App\Models\Occupations;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class OccupationController extends Controller
{
    #Bind view
     protected $view = 'admin.master.occupation.';


     #Bind occupation model
     protected $occupation;

     public function __construct(
                        
        Occupations $occupation

                        )
     {
        $this->occupation               = $occupation;
     } 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function index(Request $request)
    {
          try
        { 
             $input = $request->all();
             $occupations   =  $this->occupation->where('id','<>',null);
              if(isset($input['search_occupation']) || isset($input['search_status'])){

                if(isset($input['search_occupation']) ){
                    $occupations->where('occupation','LIKE','%'.$input['search_occupation'].'%');
                }
                if(isset($input['search_status'])){
                    $occupations->where('status', $input['search_status']);
                }
                 
               
            } 
            $details['lists'] = $occupations->orderBy('id', 'DESC')->paginate(50);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {    
             $details['occupation'] = $this->occupation->where('status',1)->get();
             
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $occupation                             = new Occupations(); 
            $occupation->occupation                    = $request->occupation ;
            $occupation->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/occupation');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->occupation->whereId($id)->first();
            
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{

            $validate = Validator::make($request->all(), [
               
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $occupation                         = Occupations::find($id);
            $occupation->occupation                    = $request->occupation ;
            $occupation->save();
        
            
             toastr()->success('Added Successfully');
            return redirect('/master/occupation');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $caste = $this->occupation::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/occupation');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

         #get the detail of requested resources
        $occupations = $this->occupation->whereId($request->id)->first();

        if($occupations->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->edupost->whereId($request->id)->update($data);
          $occupations = $this->occupation->whereId($request->id)->first();
          $message = $occupations->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/occupation');
    }
}
