<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\PanCardAvailables;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class PanCardAvailableController extends Controller
{

     #Bind view
     protected $view = 'admin.master.pancardavailable.';


     #Bind pancardavailable model
     protected $pancardavailable;

     public function __construct(
                        
        PanCardAvailables $pancardavailable

                        )
     {
        $this->pancardavailable               = $pancardavailable;
     } 



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {

             $input = $request->all();
             $pancardavailables = $this->pancardavailable->where('created_at','<>',null);
            if(isset($input['search_pancardavailable']) || isset($input['search_status'])){

                if(isset($input['search_pancardavailable']) ){
                     $pancardavailables->where('pancardavailable','LIKE','%'.$input['search_pancardavailable'].'%');
                }
                if(isset($input['search_status'])){
                     $pancardavailables->where('status', $input['search_status']);
                }
                 
               
            } 
             $details['lists'] =  $pancardavailables->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['pancardavailable'] = $this->pancardavailable->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         try{
            

            $validate = Validator::make($request->all(), [
                
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $pancardavailable                 = new PanCardAvailables();
            $pancardavailable->pancardavailable           = $request->pancardavailable;
            $pancardavailable->save();
              toastr()->success('Added Successfully');
            return redirect('/master/pancardavailable');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PanCardAvailables  $pancardavailable
     * @return \Illuminate\Http\Response
     */
    public function show(PanCardAvailables $pancardavailable)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PanCardAvailables  $pancardavailable
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->pancardavailable->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PanCardAvailables  $pancardavailable
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $pancardavailable                 =  PanCardAvailables::find($id);
            $pancardavailable->pancardavailable           = $request->pancardavailable;
            $pancardavailable->save();
             toastr()->success('Added Successfully');
            return redirect('/master/pancardavailable');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->pancardavailable::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/pancardavailable');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $pancardavailables = $this->pancardavailable->whereId($request->id)->first();

        if($pancardavailables->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->pancardavailable->whereId($request->id)->update($data);
          $pancardavailables = $this->pancardavailable->whereId($request->id)->first();
          $message = $pancardavailables->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/pancardavailable');
    }
}
