<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\PaymentFacility;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class PaymentFacilityController extends Controller
{

    #Bind view
    protected $view = 'admin.master.paymentfacilityback.';


    #Bind paymentfacilityback model
    protected $paymentfacilityback;

    public function __construct(

        PaymentFacility $paymentfacilityback

    ) {
        $this->paymentfacilityback               = $paymentfacilityback;
    }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {

            $input = $request->all();
            $paymentfacilitybacks = $this->paymentfacilityback->where('created_at', '<>', null);
            if (isset($input['search_heading']) || isset($input['search_status'])) {

                if (isset($input['search_heading'])) {
                    $$paymentfacilitybacks->where('heading', 'LIKE', '%' . $input['search_heading'] . '%');
                }
                if (isset($input['search_status'])) {
                    $paymentfacilitybacks->where('status', $input['search_status']);
                }
            }
            $details['lists'] =  $paymentfacilitybacks->orderBy('id', 'DESC')->paginate(10);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try {
            $details['paymentfacilityback'] = $this->paymentfacilityback->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        try {


            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $paymentfacilityback                 = new PaymentFacility();
            $paymentfacilityback->url            = isset($request->url) ? fileUpload('public/admin/home/paymentfacilityback', $request->file('url')) : '';;
            $paymentfacilityback->heading           = $request->heading;
            $paymentfacilityback->description           = $request->description;
            $paymentfacilityback->save();
            toastr()->success('Added Successfully');
            return redirect('/master/paymentfacilityback');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\paymentfacilityback  $paymentfacilityback
     * @return \Illuminate\Http\Response
     */
    public function show(PaymentFacility $paymentfacilityback)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\paymentfacilityback  $paymentfacilityback
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {

            $details['detail'] = $this->paymentfacilityback->whereId($id)->first();

            #render view
            return view($this->view . 'edit', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\paymentfacilityback  $paymentfacilityback
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $paymentfacilityback                             =  PaymentFacility::find($id);
            if (isset($request->url))
                $paymentfacilityback->url                        = isset($request->url) ? fileUpload('public/admin/home/paymentfacilityback', $request->file('url')) : '';
            $paymentfacilityback->heading                       = $request->heading;
            $paymentfacilityback->description                       = $request->description;
            $paymentfacilityback->save();
            toastr()->success('Update Successfully');
            return redirect('/master/paymentfacilityback');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->paymentfacilityback::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/paymentfacilityback');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $paymentfacilitybacks = $this->paymentfacilityback->whereId($request->id)->first();

        if ($paymentfacilitybacks->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->paymentfacilityback->whereId($request->id)->update($data);
        $paymentfacilitybacks = $this->paymentfacilityback->whereId($request->id)->first();
        $message = $paymentfacilitybacks->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/paymentfacilityback');
    }
}
