<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Country;
use App\Models\State;
use App\Models\City;
use App\Models\Event;
use App\Models\ContactInfo;
use App\Models\FamilyInfo;
use App\Models\PersonalInfo;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class PersonalInfoController extends Controller
{
    protected $view = 'admin.master.personalinfo.';


     #Bind PersonalInfo model
     protected $personalinfo;

    #Bind ContactInfo model
     protected $contactinfo;


     #Bind FamilyInfo model
     protected $familyinfo;


     #Bind Event model
     protected $event;


     public function __construct(
                        
                        City $city,
                        Event $event,
                        State $state,
                        Country $country,
                        FamilyInfo $familyinfo,
                        ContactInfo $contactinfo,
                        personalinfo $personalinfo
                       

                        )
     {
        $this->event                      = $event;
        $this->familyinfo                 = $familyinfo;
        $this->contactinfo                = $contactinfo;
        $this->personalinfo               = $personalinfo;
        $this->country                    = $country;
        $this->state                      = $state;
        $this->city                       = $city;
        

      }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try
        {
            $details['lists'] = $this->personalinfo->orderBy('id', 'DESC')->paginate(50);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['personalinfo'] = $this->personalinfo->where('status',1)->get();
             
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

       try{

            

            $validate = Validator::make($request->all(), [
                   
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $personalinfo                      = new PersonalInfo(); 
            $personalinfo->image               = isset($request->image) ? fileUpload('public/admin/home/personalinfo',$request->file('image')): '';
            $personalinfo->gender              = $request->gender;
            $personalinfo->register_for        = $request->register_for;
            $personalinfo->canditate_name      = $request->canditate_name;
            $personalinfo->dob                 = $request->dob;
            $personalinfo->birth_place         = $request->birth_place;
            $personalinfo->height              = $request->height;
            $personalinfo->caste               = $request->caste;
            $personalinfo->sub_caste           = $request->sub_caste;
            $personalinfo->education           = $request->education;
            $personalinfo->farm_area           = $request->farm_area;
            $personalinfo->occupation          = $request->occupation;
            $personalinfo->a_income            = $request->a_income;
            $personalinfo->rashi               = $request->rashi;
            $personalinfo->blood_group         = $request->blood_group;
            $personalinfo->save();
     
             toastr()->success('Added Successfully');
            return redirect('/register/personalinfo');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            $details['detail']        = $this->personalinfo->whereId($id)->first();
            $details['city']          = $this->city->where('status',1)->get();
            $details['state']         = $this->state->where('status',1)->get();
            $details['country']       = $this->country->where('status',1)->get();
            $details['contactinfosss']   = $this->contactinfo->where('personal_info_id',$id)->first();
            $details['event']         = $this->event->where('status',1)->get();
            $details['familyinfosss']    = $this->familyinfo->where('personal_info_id',$id)->first();

            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [
               
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $personalinfo                      = PersonalInfo::find($id);
            if($request->image)
            $personalinfo->image               = isset($request->image) ? fileUpload('public/admin/home/personalinfo',$request->file('image')): '';
            $personalinfo->gender              = $request->gender;
            $personalinfo->register_for        = $request->register_for;
            $personalinfo->canditate_name      = $request->canditate_name;
            $personalinfo->dob                 = $request->dob;
            $personalinfo->birth_place         = $request->birth_place;
            $personalinfo->height              = $request->height;
            $personalinfo->caste               = $request->caste;
            $personalinfo->sub_caste           = $request->sub_caste;
            $personalinfo->education           = $request->education;
            $personalinfo->farm_area           = $request->farm_area;
            $personalinfo->occupation          = $request->occupation;
            $personalinfo->a_income            = $request->a_income;
            $personalinfo->rashi               = $request->rashi;
            $personalinfo->blood_group         = $request->blood_group;
            $personalinfo->save();
            

            $personalinfo->save();
            
             toastr()->success('Added Successfully');
            return redirect('/register/personalinfo');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

       /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->personalinfo::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('register/personalinfo');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $personalinfos = $this->personalinfo->whereId($request->id)->first();

        if($personalinfos->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->personalinfo->whereId($request->id)->update($data);
          $personalinfos = $this->personalinfo->whereId($request->id)->first();
          $message = $personalinfos->status ==0 ? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('register/personalinfo');
    }
}
