<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\PersonalInfoForms;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class PersonalInfoFormController extends Controller
{
    #Bind view
    protected $view = 'admin.master.personalinfoform.';


    #Bind personalinfoform model
    protected $personalinfoform;

    public function __construct(

        PersonalInfoForms $personalinfoform

    ) {
        $this->personalinfoform                = $personalinfoform;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        try {
            $input = $request->all();
            $personalinfoforms   =  $this->personalinfoform->where('id', '<>', null);
            if (isset($input['search_fname']) || isset($input['search_status'])) {

                if (isset($input['search_fname'])) {
                    $personalinfoforms->where('fname', 'LIKE', '%' . $input['search_fname'] . '%');
                }
                if (isset($input['search_status'])) {
                    $personalinfoforms->where('status', $input['search_status']);
                }
            }
            $details['lists'] = $personalinfoforms->orderBy('id', 'DESC')->paginate(50);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        try {
            $details['personalinfoform'] = $this->personalinfoform->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {



            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $personalinfoform                             = new PersonalInfoForms();
            $personalinfoform->accounttype                    = $request->accounttype;
            $personalinfoform->branch                       = $request->branch;
            $personalinfoform->orating_rigths                = $request->orating_rigths;
            $personalinfoform->orating_rigths_other                    = $request->orating_rigths_other;
            $personalinfoform->salutation                = $request->salutation;
            $personalinfoform->fname                    = $request->fname;
            $personalinfoform->mname                = $request->mname;
            $personalinfoform->lname                    = $request->lname;
            $personalinfoform->date_of_birth                = $request->date_of_birth;

            $personalinfoform->gender               = $request->gender;

            $personalinfoform->pancardavailable                = $request->pancardavailable;
            $personalinfoform->pan_number                    = $request->pan_number;
            $personalinfoform->aadhar_number                = $request->aadhar_number;
            $personalinfoform->email                    = $request->email;
            $personalinfoform->landline                = $request->landline;
            $personalinfoform->mobile_no                    = $request->mobile_no;
            $personalinfoform->whats_app_mono                = $request->whats_app_mono;
            $personalinfoform->nationality                    = $request->nationality;
            $personalinfoform->religion                = $request->religion;
            $personalinfoform->category                    = $request->category;
            $personalinfoform->education                = $request->education;
            $personalinfoform->occupation                    = $request->occupation;
            $personalinfoform->maritalstatus                = $request->maritalstatus;

            $personalinfoform->salutation2        = $request->salutation2;
            $personalinfoform->father_fname                = $request->father_fname;
            $personalinfoform->father_mname                    = $request->father_mname;
            $personalinfoform->father_lname                = $request->father_lname;

            $personalinfoform->salutation3                    = $request->salutation3;
            $personalinfoform->mother_fname                = $request->mother_fname;
            $personalinfoform->mother_mname                    = $request->mother_mname;
            $personalinfoform->mother_lname                = $request->mother_lname;

            $personalinfoform->p_address                    = $request->p_address;
            $personalinfoform->p_city                = $request->p_city;
            $personalinfoform->p_taluka                    = $request->p_taluka;
            $personalinfoform->p_district                = $request->p_district;
            $personalinfoform->p_pin                    = $request->p_pin;
            $personalinfoform->p_state                = $request->p_state;

            $personalinfoform->t_address        = $request->t_address;
            $personalinfoform->t_city                = $request->t_city;
            $personalinfoform->t_taluka                    = $request->t_taluka;
            $personalinfoform->t_district                = $request->t_district;
            $personalinfoform->t_pin                    = $request->t_pin;
            $personalinfoform->t_state                = $request->t_state;
            $personalinfoform->save();

            toastr()->success('Added Successfully');
            return redirect('/master/personalinfoform');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //    try
        //     {




        $details['detail'] = $this->personalinfoform->whereId($id)->first();

        return view($this->view . 'edit', $details);
        // }catch(\Exception $ex)
        // {
        //     toastr()->success($ex->getMessage());
        //     return back()->with('error', $ex->getMessage());
        // }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $personalinfoform                         = PersonalInfoForms::find($id);
            $personalinfoform->accounttype                   = $request->accounttype;
            $personalinfoform->branch                       = $request->branch;
            $personalinfoform->orating_rigths                = $request->orating_rigths;
            $personalinfoform->orating_rigths_other                    = $request->orating_rigths_other;
            $personalinfoform->salutation                = $request->salutation;
            $personalinfoform->fname                    = $request->fname;
            $personalinfoform->mname                = $request->mname;
            $personalinfoform->lname                    = $request->lname;
            $personalinfoform->date_of_birth                = $request->date_of_birth;

            $personalinfoform->gender               = $request->gender;

            $personalinfoform->pancardavailable                = $request->pancardavailable;
            $personalinfoform->pan_number                    = $request->pan_number;
            $personalinfoform->aadhar_number                = $request->aadhar_number;
            $personalinfoform->email                    = $request->email;
            $personalinfoform->landline                = $request->landline;
            $personalinfoform->mobile_no                    = $request->mobile_no;
            $personalinfoform->whats_app_mono                = $request->whats_app_mono;
            $personalinfoform->nationality                    = $request->nationality;
            $personalinfoform->religion                = $request->religion;
            $personalinfoform->category                    = $request->category;
            $personalinfoform->education                = $request->education;
            $personalinfoform->occupation                    = $request->occupation;
            $personalinfoform->maritalstatus                = $request->maritalstatus;

            $personalinfoform->salutation2                  = $request->salutation2;
            $personalinfoform->father_fname                = $request->father_fname;
            $personalinfoform->father_mname                    = $request->father_mname;
            $personalinfoform->father_lname                = $request->father_lname;

            $personalinfoform->salutation3                    = $request->salutation3;
            $personalinfoform->mother_fname                = $request->mother_fname;
            $personalinfoform->mother_mname                    = $request->mother_mname;
            $personalinfoform->mother_lname                = $request->mother_lname;

            $personalinfoform->p_address                    = $request->p_address;
            $personalinfoform->p_city                = $request->p_city;
            $personalinfoform->p_taluka                    = $request->p_taluka;
            $personalinfoform->p_district                = $request->p_district;
            $personalinfoform->p_pin                    = $request->p_pin;
            $personalinfoform->p_state                = $request->p_state;

            $personalinfoform->t_address        = $request->t_address;
            $personalinfoform->t_city                = $request->t_city;
            $personalinfoform->t_taluka                    = $request->t_taluka;
            $personalinfoform->t_district                = $request->t_district;
            $personalinfoform->t_pin                    = $request->t_pin;
            $personalinfoform->t_state                = $request->t_state;
            $personalinfoform->save();


            toastr()->success('Update Successfully');
            return redirect('/master/personalinfoform');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->personalinfoform::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/personalinfoform');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $personalinfoforms = $this->personalinfoform->whereId($request->id)->first();

        if ($personalinfoforms->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->personalinfoform->whereId($request->id)->update($data);
        $personalinfoforms = $this->personalinfoform->whereId($request->id)->first();
        $message = $personalinfoforms->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/personalinfoform');
    }
}
