<?php

namespace App\Http\Controllers\Admin\Master;
use App\Models\RegisterForms;
use App\Models\Standards;
use App\Models\Streams;
use App\Models\Genders;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class RegisterFormController extends Controller
{
    #Bind view
     protected $view = 'admin.master.registerfrom.';


     #Bind registerfrom model
     protected $registerfrom;

     public function __construct(
                        
        RegisterForms $registerfrom,
        Standards $standard,
        Streams $stream,
        Genders $gender

                        )
     {
        $this->registerfrom               = $registerfrom;
        $this->standard                      = $standard;
        $this->stream               = $stream;
        $this->gender               = $gender;
     } 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function index(Request $request)
    {
          try
        { 
             $input = $request->all();
             $registerfroms   =  $this->registerfrom->where('id','<>',null);
              if(isset($input['search_heading']) || isset($input['search_status'])){

                if(isset($input['search_heading']) ){
                    $registerfroms->where('heading','LIKE','%'.$input['search_heading'].'%');
                }
                if(isset($input['search_status'])){
                    $registerfroms->where('status', $input['search_status']);
                }
                 
               
            } 
            $details['lists'] = $registerfroms->orderBy('id', 'DESC')->paginate(50);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
       try
        {    
             $details['registerfrom'] = $this->registerfrom->where('status',1)->get();
             $details['standard'] = $this->standard->where('status',1)->get();
            
             $details['stream'] = $this->stream->where('status',1)->get();
             $details['gender'] = $this->gender->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $registerfrom                             = new RegisterForms(); 
            $registerfrom->email                    = $request->email ;
            $registerfrom->aadharid                = $request->aadharid ;
            $registerfrom->nameofchild                    = $request->nameofchild ;

            $registerfrom->class_id                = $request->class_id ;
            $registerfrom->dateofbirth                    = $request->dateofbirth ;

            $registerfrom->stream_id                = $request->stream_id ;
            $registerfrom->gender_id                    = $request->gender_id ;
            $registerfrom->nationality                = $request->nationality ;
            $registerfrom->nameofpreviousschool        = $request->nameofpreviousschool ;
            $registerfrom->fathername                = $request->fathername ;
            $registerfrom->mothername                    = $request->mothername ;
            $registerfrom->fatherphone                = $request->fatherphone ;
            $registerfrom->motherphone                    = $request->motherphone ;
            $registerfrom->address                = $request->address ;
            $registerfrom->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/registerfrom');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
    //    try
    //     {
           
            $details['detail'] = $this->registerfrom->whereId($id)->first();
            $details['standard'] = $this->standard->whereId($id)->get();
            $details['stream'] = $this->stream->whereId($id)->first()->get();
            $details['gender'] = $this->gender->whereId($id)->first()->get();
            
            return view($this->view.'edit',$details);
        // }catch(\Exception $ex)
        // {
        //     toastr()->success($ex->getMessage());
        //     return back()->with('error', $ex->getMessage());
        // }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       try{

            $validate = Validator::make($request->all(), [
               
            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $registerfrom                         = RegisterForms::find($id);
            $registerfrom->email                    = $request->email ;
            $registerfrom->aadharid                = $request->aadharid ;
            $registerfrom->nameofchild                    = $request->nameofchild ;

            $registerfrom->class_id                = $request->class_id ;
            $registerfrom->dateofbirth                    = $request->dateofbirth ;

            $registerfrom->stream_id                = $request->stream_id ;
            $registerfrom->gender_id                    = $request->gender_id ;
            $registerfrom->nationality                = $request->nationality ;
            $registerfrom->nameofpreviousschool                    = $request->nameofpreviousschool ;
            $registerfrom->fathername                = $request->fathername ;
            $registerfrom->mothername                    = $request->mothername ;
            $registerfrom->fatherphone                = $request->fatherphone ;
            $registerfrom->motherphone                    = $request->motherphone ;
            $registerfrom->address                = $request->address ;
            $registerfrom->save();
        
            
             toastr()->success('Added Successfully');
            return redirect('/master/registerfrom');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $caste = $this->registerfrom::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/registerfrom');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

         #get the detail of requested resources
        $registerfroms = $this->registerfrom->whereId($request->id)->first();

        if($registerfroms->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->registerfrom->whereId($request->id)->update($data);
          $registerfroms = $this->registerfrom->whereId($request->id)->first();
          $message = $registerfroms->status ==0? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/registerfrom');
    }
}
