<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\SocietyChairmanImages;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class SocietyChairmanImageController extends Controller
{

    #Bind view
    protected $view = 'admin.master.societychairmanimage.';


    #Bind societychairmanimage model
    protected $societychairmanimage;

    public function __construct(

        SocietyChairmanImages $societychairmanimage

    ) {
        $this->societychairmanimage               = $societychairmanimage;
    }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {

            $input = $request->all();
            $societychairmanimages = $this->societychairmanimage->where('created_at', '<>', null);
            if (isset($input['search_name']) || isset($input['search_status'])) {

                if (isset($input['search_name'])) {
                    $societychairmanimages->where('name', 'LIKE', '%' . $input['search_name'] . '%');
                }
                if (isset($input['search_status'])) {
                    $societychairmanimages->where('status', $input['search_status']);
                }
            }
            $details['lists'] =  $societychairmanimages->orderBy('id', 'DESC')->paginate(10);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try {
            $details['societychairmanimage'] = $this->societychairmanimage->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        try {


            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $societychairmanimage                 = new SocietyChairmanImages();
            $societychairmanimage->image           = isset($request->image) ? fileUpload('public/admin/master/societychairmanimage', $request->file('image')) : '';
            $societychairmanimage->name           = $request->name;
            $societychairmanimage->post           = $request->post;
            $societychairmanimage->save();
            toastr()->success('Added Successfully');
            return redirect('/master/societychairmanimage');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\SocietyChairmanImages  $societychairmanimage
     * @return \Illuminate\Http\Response
     */
    public function show(SocietyChairmanImages $societychairmanimage)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\SocietyChairmanImages  $societychairmanimage
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {

            $details['detail'] = $this->societychairmanimage->whereId($id)->first();

            #render view
            return view($this->view . 'edit', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\societychairmanimages  $societychairmanimage
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $societychairmanimage =                SocietyChairmanImages::find($id);
            if (isset($request->image))
                $societychairmanimage->image           = isset($request->image) ? fileUpload('public/admin/master/societychairmanimage', $request->file('image')) : '';
            $societychairmanimage->name            = $request->name;
            $societychairmanimage->post           = $request->post;
            $societychairmanimage->save();
            toastr()->success('Update Successfully');
            return redirect('/master/societychairmanimage');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->societychairmanimage::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/societychairmanimage');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $societychairmanimages = $this->societychairmanimage->whereId($request->id)->first();

        if ($societychairmanimages->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->societychairmanimage->whereId($request->id)->update($data);
        $societychairmanimages = $this->societychairmanimage->whereId($request->id)->first();
        $message = $societychairmanimages->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/societychairmanimage');
    }
}
