<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\SocietyDirectorImages;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class SocietyDirectorImageController extends Controller
{

    #Bind view
    protected $view = 'admin.master.societydirectorimage.';


    #Bind societydirectorimage model
    protected $societydirectorimage;

    public function __construct(

        SocietyDirectorImages $societydirectorimage

    ) {
        $this->societydirectorimage               = $societydirectorimage;
    }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try {

            $input = $request->all();
            $societydirectorimages = $this->societydirectorimage->where('created_at', '<>', null);
            if (isset($input['search_name']) || isset($input['search_status'])) {

                if (isset($input['search_name'])) {
                    $societydirectorimages->where('name', 'LIKE', '%' . $input['search_name'] . '%');
                }
                if (isset($input['search_status'])) {
                    $societydirectorimages->where('status', $input['search_status']);
                }
            }
            $details['lists'] =  $societydirectorimages->orderBy('id', 'DESC')->paginate(10);
            #render view
            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try {
            $details['societydirectorimage'] = $this->societydirectorimage->where('status', 1)->get();
            #render view
            return view($this->view . 'create', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        try {


            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {

                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $societydirectorimage                 = new SocietyDirectorImages();
            $societydirectorimage->image           = isset($request->image) ? fileUpload('public/admin/master/societydirectorimage', $request->file('image')) : '';
            $societydirectorimage->name           = $request->name;
            $societydirectorimage->post           = $request->post;
            $societydirectorimage->save();
            toastr()->success('Added Successfully');
            return redirect('/master/societydirectorimage');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\societydirectorimages  $societydirectorimage
     * @return \Illuminate\Http\Response
     */
    public function show(societydirectorimages $societydirectorimage)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\societydirectorimages  $societydirectorimage
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {

            $details['detail'] = $this->societydirectorimage->whereId($id)->first();

            #render view
            return view($this->view . 'edit', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\societydirectorimages  $societydirectorimage
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {

            $validate = Validator::make($request->all(), []);

            if ($validate->fails()) {
                toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }

            $societydirectorimage =                SocietyDirectorImages::find($id);
            if (isset($request->image))
                $societydirectorimage->image           = isset($request->image) ? fileUpload('public/admin/master/societydirectorimage', $request->file('image')) : '';
            $societydirectorimage->name            = $request->name;
            $societydirectorimage->post           = $request->post;
            $societydirectorimage->save();
            toastr()->success('Update Successfully');
            return redirect('/master/societydirectorimage');
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->societydirectorimage::find($id);
        $caste->delete();
        toastr()->success('You are successfully Deleted');
        return redirect('master/societydirectorimage');
    }
    /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request, $id)
    {

        #get the detail of requested resources
        $societydirectorimages = $this->societydirectorimage->whereId($request->id)->first();

        if ($societydirectorimages->status == 1) {
            $status = '0';
        } else {
            $status = '1';
        }
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->societydirectorimage->whereId($request->id)->update($data);
        $societydirectorimages = $this->societydirectorimage->whereId($request->id)->first();
        $message = $societydirectorimages->status == 0 ? 'InActive' : 'Active';
        toastr()->success('You are successfully ' . $message);
        return redirect('master/societydirectorimage');
    }
}
