<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Country;
use App\Models\State;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class StateController extends Controller
{
    protected $view = 'admin.master.state.';


     #Bind year model
     protected $state;


     public function __construct(
                        
                        Country $country,
                        State $state
                       

                        )
     {
        $this->country                    = $country;
        $this->state                      = $state;
        

      }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try
        {
             $input = $request->all();
             $states = $this->state->where('id','<>',null);
              if(isset($input['search_name']) || isset($input['search_status'])){

                if(isset($input['search_name']) ){
                    $states->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                    $states->where('status', $input['search_status']);
                }
                 
               
            } 
            $details['lists'] = $states->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['state'] = $this->state->where('status',1)->get();
             $details['country'] = $this->country->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{

            

            $validate = Validator::make($request->all(), [
                    'name' => 'required',
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $state                 = new State();
            $state->country_id        = $request->country_id ;
            $state->name           = $request->name;
            
            $state->save();
     
             toastr()->success('Added Successfully');
            return redirect('/master/state');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }
    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->state->whereId($id)->first();
            $details['country'] = $this->country->where('status',1)->get();
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [
                'name' => 'required',

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $state                 =State::find($id);
            $state->country_id     = $request->country_id ;
            $state->name           = $request->name;
           
            $state->save();
             toastr()->success('Added Successfully');
            return redirect('/master/state');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         $caste = $this->state::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/state');
    }
     /**
     * change status of specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $states = $this->state->whereId($request->id)->first();

        if($states->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->state->whereId($request->id)->update($data);
          $states = $this->state->whereId($request->id)->first();
          $message = $states->status ==1? 'Active' : 'InActive';
       toastr()->success('You are successfully '.$message);
       return redirect('master/state');
    }
    
    public function countryWiseState(Request $request){
         $details['state'] = $this->state->where('country_id',$request->country_id)->where('status',1)->get();
          #render view
        return view($this->view.'option',$details);
    }
}
