<?php

namespace App\Http\Controllers\Admin\Master;

use App\Models\Year;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class YearController extends Controller
{
     #Bind view
     protected $view = 'admin.master.year.';


     #Bind year model
     protected $year;

     public function __construct(
                        
                        Year $year

                        )
     {
        $this->year               = $year;
     } 



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       try
        {
             $input = $request->all();
             $gallery = $this->year->where('created_at','<>',null);
              if(isset($input['search_name']) || isset($input['search_status']) ){

                if(isset($input['search_name']) ){
                    $gallery->where('name','LIKE','%'.$input['search_name'].'%');
                }
                if(isset($input['search_status'])){
                    $gallery->where('status', $input['search_status']);
                }
                
               
            } 
             $details['lists'] = $gallery->orderBy('id', 'DESC')->paginate(10);
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['year'] = $this->year->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


         try{
            

            $validate = Validator::make($request->all(), [
                    'name' => 'required',
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            $year                 = new 	Year();
            $year->name           = $request->name;
            $year->save();
              toastr()->success('Added Successfully');
            return redirect('/master/year');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\year  $year
     * @return \Illuminate\Http\Response
     */
    public function show(Year $year)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\year  $year
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       try
        {
            
            $details['detail'] = $this->year->whereId($id)->first();
            
            #render view
            return view($this->view.'edit',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\year  $year
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{

            $validate = Validator::make($request->all(), [
                'name' => 'required',

            ]);

            if($validate->fails()){
                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
    
            $year =  Year::find($id);
            $year->name= $request->name;
            $year->save();
             toastr()->success('Added Successfully');
            return redirect('/master/year');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\year  $year
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $caste = $this->year::find($id);
        $caste ->delete();
         toastr()->success('You are successfully Deleted');
       return redirect('master/year');
    }

    public function changeStatus(Request $request,$id)
    {

        #get the detail of requested resources
        $years = $this->year->whereId($request->id)->first();

        if($years->status == 1){
             $status = '0';
        }else{
              $status = '1';
        }        
        #get the status in data variable
        $data = ['status' => $status];

        #update status
        $this->year->whereId($request->id)->update($data);
          $years = $this->year->whereId($request->id)->first();
          $message = $years->status ==0 ? 'InActive' : 'Active';
       toastr()->success('You are successfully '.$message);
       return redirect('master/year');
    }
}
