<?php

namespace App\Http\Controllers\Frontend;

use App\Models\RegisterWithUs;
use App\Models\Country;
use App\Models\State;


# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FrontenRegisterController extends Controller
{
     #Bind view
     protected $view = 'frontend.register.';

    #Bind Country model
    protected $register;

    #Bind Country model
    protected $country;

    #Bind State model
    protected $state;

     public function __construct(
                        RegisterWithUs $registerwithus,
                        Country $country,
                        State $state
                       

                        )
     {
        $this->registerwithus       = $registerwithus;
        $this->country              = $country;
        $this->state                = $state;
        
      }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       try
        {
            $details['registerwithus'] = $this->registerwithus->where('status',1)->get();
            $details['country'] = $this->country->where('status',1)->get();
            $details['state']   = $this->state->where('country_id',1)->get();
              $details['data'] = '';
                #render view
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       try
        {    
            $details['registerwithus'] = $this->registerwithus->where('status',1)->get();
           
            
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

      
        try{

           

            $validate = Validator::make($request->all(), [
                    
                    
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $register                      = new RegisterWithUs(); 
            $register->f_name              = $request->f_name;
            $register->m_name              = $request->m_name;
            $register->l_name              = $request->l_name;
            $register->n_address1          = $request->n_address1;
            $register->n_address2          = $request->n_address2;
            $register->n_country_id        = $request->n_country_id;
            $register->n_state_id          = $request->n_state_id;
            $register->n_city              = $request->n_city;
            $register->n_pincode           = $request->n_pincode;
            $register->p_address1          = $request->p_address1;
            $register->p_address2          = $request->p_address2;
            $register->p_country_id        = $request->p_country_id;
            $register->p_state_id          = $request->p_state_id;
            $register->p_city              = $request->p_city;
            $register->p_pincode           = $request->p_pincode;
            $register->save();
            toastr()->success('Added Successfully');
           
            return redirect()->back()->with('success', 'ok');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }


       /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    

       /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
