<?php

namespace App\Http\Controllers\Frontend;

use App\Models\PersonalInfoForms;
use App\Models\AccountInquiryForms;
use App\Models\NominationForms;
use App\Models\IntroducerForms;
use App\Models\Banner;



# Other Classes
use DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class FrontendApplicationFormController extends Controller
{
    #Bind view
    protected $view = 'frontend.applicationform.';


    #Bind banner model
    protected $banner;


    public function __construct(

        Banner $banner,
        PersonalInfoForms $personalinfoform,
        AccountInquiryForms $accountinquiryform,
        NominationForms $nominationform,
        IntroducerForms $introducerform

    ) {
        $this->banner                           = $banner;
        $this->personalinfoform                = $personalinfoform;
        $this->accountinquiryform               = $accountinquiryform;
        $this->nominationform               = $nominationform;
        $this->introducerform                = $introducerform;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        //    try
        //     {    

        $details['banner'] = $this->banner->where('type', '=', 'applicationform')->orderBy('id', 'DESC')->get();
        $details['personalinfoform'] = $this->personalinfoform->where('status', 1)->get();
        $details['accountinquiryform'] = $this->accountinquiryform->where('status', 1)->get();
        $details['nominationform'] = $this->nominationform->where('status', 1)->get();
        $details['introducerform'] = $this->introducerform->where('status', 1)->get();


        #render view

        return view($this->view . 'index', $details);
        // }catch(\Exception $ex)
        // {
        //     toastr()->success($ex->getMessage());
        //     return back()->with('error', $ex->getMessage());
        // }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       
        // try
        // {
        //     $validate = Validator::make($request->all(), [

        //     ]);

        //     if($validate->fails()){

        //          toastr()->error($validate->messages());
        //         return redirect()->back()->withInput();
        //     }
        DB::beginTransaction();
       
        $personalinfoform                             = new PersonalInfoForms();
        $personalinfoform->accounttype                    = $request->accounttype;
        $personalinfoform->branch                       = $request->branch;
        $personalinfoform->orating_rigths                = $request->orating_rigths;
        $personalinfoform->orating_rigths_other         = $request->orating_rigths_other;
        $personalinfoform->salutation                = $request->salutation;
        $personalinfoform->fname                    = $request->fname;
        $personalinfoform->mname                = $request->mname;
        $personalinfoform->lname                    = $request->lname;
        $personalinfoform->date_of_birth                = $request->date_of_birth;
        $personalinfoform->gender               = $request->gender;
        $personalinfoform->pancardavailable                = $request->pancardavailable;
        $personalinfoform->pan_number                    = $request->pan_number;
        $personalinfoform->aadhar_number                = $request->aadhar_number;
        $personalinfoform->email                    = $request->email;
        $personalinfoform->landline                = $request->landline;
        $personalinfoform->mobile_no                    = $request->mobile_no;
        $personalinfoform->whats_app_mono                = $request->whats_app_mono;
        $personalinfoform->nationality                    = $request->nationality;
        $personalinfoform->religion                = $request->religion;
        $personalinfoform->category                    = $request->category;
        $personalinfoform->education                = $request->education;
        $personalinfoform->occupation                    = $request->occupation;
        $personalinfoform->maritalstatus                = $request->maritalstatus;
        $personalinfoform->salutation2        = $request->salutation2;
        $personalinfoform->father_fname                = $request->father_fname;
        $personalinfoform->father_mname                    = $request->father_mname;
        $personalinfoform->father_lname                = $request->father_lname;
        $personalinfoform->salutation3                    = $request->salutation3;
        $personalinfoform->mother_fname                = $request->mother_fname;
        $personalinfoform->mother_mname                    = $request->mother_mname;
        $personalinfoform->mother_lname                = $request->mother_lname;
        $personalinfoform->p_address                    = $request->p_address;
        $personalinfoform->p_city                = $request->p_city;
        $personalinfoform->p_taluka                    = $request->p_taluka;
        $personalinfoform->p_district                = $request->p_district;
        $personalinfoform->p_pin                    = $request->p_pin;
        $personalinfoform->p_state                = $request->p_state;
        $personalinfoform->t_address        = $request->t_address;
        $personalinfoform->t_city                = $request->t_city;
        $personalinfoform->t_taluka                    = $request->t_taluka;
        $personalinfoform->t_district                = $request->t_district;
        $personalinfoform->t_pin                    = $request->t_pin;
        $personalinfoform->t_state                = $request->t_state;
        $personalinfoform->save();
        DB::commit();


       



        



        
        
        // }catch(\Exception $ex)
        // {DB::rollback();
        //     toastr()->success($ex->getMessage());
        //     return back()->with('error', $ex->getMessage());
        // }
    }

    public function secondForm(Request $request){
        $perinfo = $this->personalinfoform->get()->last();
       
        $accountinquiryform                             = new AccountInquiryForms();
        $accountinquiryform->per_id                         = $perinfo->id;
        $accountinquiryform->depositing_amount             = $request->depositing_amount;
        $accountinquiryform->depositing_amount_word        = $request->depositing_amount_word;
        $accountinquiryform->atm_card                    = $request->atm_card == 'एटीएम आणि डेबिट कार्ड' ? '1' : '0';
        $accountinquiryform->sms_alerts                    = $request->sms_alerts == 'एसएमएस अलर्ट' ? '1' : '0';
        $accountinquiryform->statement_email                = $request->statement_email == 'ईमेलद्वारे निवेदने' ? '1' : '0';
        $accountinquiryform->document                      = $request->document;
        $accountinquiryform->save();
    }

    public function thirdForm(Request $request){
        $perinfo = $this->personalinfoform->get()->last();
        $nominationform                                    = new NominationForms();
        $nominationform->per_id                         = $perinfo->id;
        $nominationform->saluta                           = $request->saluta;
        $nominationform->fname                            = $request->fname;
        $nominationform->mname                           = $request->mname;
        $nominationform->lname                           = $request->lname;
        $nominationform->relationship                    = $request->relationship;
        $nominationform->date_of_birth                        = $request->date_of_birth;
        $nominationform->nominee_minor                      = $request->nominee_minor == 'वारस अल्पवयीन आहे का?' ? '1' : '0';
        $nominationform->residential_address                     = $request->residential_address;
        $nominationform->residential_city                = $request->residential_city;
        $nominationform->residential_taluka                    = $request->residential_taluka;
        $nominationform->residential_district                    = $request->residential_district;
        $nominationform->residential_pin                          = $request->residential_pin;
        $nominationform->residential_state                      = $request->residential_state;
        $nominationform->permanent_address                    = $request->permanent_address;
        $nominationform->permanent_city                          = $request->permanent_city;
        $nominationform->permanent_taluka                    = $request->permanent_taluka;
        $nominationform->permanent_district                    = $request->permanent_district;
        $nominationform->permanent_pin                           = $request->permanent_pin;
        $nominationform->permanent_state                      = $request->permanent_state;
        $nominationform->saluta2                                     = $request->saluta2;
        $nominationform->guardian_fname                              = $request->guardian_fname;
        $nominationform->guardian_mname                             = $request->guardian_mname;
        $nominationform->guardian_lname                             = $request->guardian_lname;
        $nominationform->guardian_date_of_birth                    = $request->guardian_date_of_birth;
        $nominationform->guardian_residential_address                = $request->guardian_residential_address;
        $nominationform->guardian_residential_city                      = $request->guardian_residential_city;
        $nominationform->guardian_residential_taluka                 = $request->guardian_residential_taluka;
        $nominationform->guardian_residential_district                  = $request->guardian_residential_district;
        $nominationform->guardian_residential_pin                    = $request->guardian_residential_pin;
        $nominationform->guardian_residential_state                    = $request->guardian_residential_state;
        $nominationform->guardian_permanent_address                        = $request->guardian_permanent_address;
        $nominationform->guardian_permanent_city                      = $request->guardian_permanent_city;
        $nominationform->guardian_permanent_taluka                          = $request->guardian_permanent_taluka;
        $nominationform->guardian_permanent_district                     = $request->guardian_permanent_district;
        $nominationform->guardian_permanent_pin                    = $request->guardian_permanent_pin;
        $nominationform->guardian_permanent_state                    = $request->guardian_permanent_state;
        $nominationform->save();
    }

    public function fourthForm(Request $request){
        $perinfo = $this->personalinfoform->get()->last();
        $introducerform                                               = new IntroducerForms();
        $introducerform->per_id                                         = $perinfo->id;
        $introducerform->salutat                                   = $request->salutat;
        $introducerform->fname                                      = $request->fname;
        $introducerform->mname                                       = $request->mname;
        $introducerform->lname                                       = $request->lname;
        $introducerform->accounttype1                                = $request->accounttype1;
        $introducerform->introducer_account_number                      = $request->introducer_account_number;
        $introducerform->known_account_holder_since                  = $request->known_account_holder_since;
        $introducerform->address                                     = $request->address;
        $introducerform->city                                       = $request->city;
        $introducerform->taluka                                      = $request->taluka;
        $introducerform->district                                      = $request->district;
        $introducerform->pin                                          = $request->pin;
        $introducerform->state                                         = $request->state;
        $introducerform->save();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
