<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Banner;
use App\Models\ChairmanImages;
use App\Models\DirectorImages;
use App\Models\FacebookBanners;
use App\Models\Accounts;
use App\Models\Video;
use App\Models\SocietyChairmanImages;
use App\Models\SocietyDirectorImages;
use App\Models\Discreption;


# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FrontendHomeController extends Controller
{
    #Bind view
    protected $view = 'frontend.home.';


    #Bind Banner model
    protected $banner;


    public function __construct(

        Banner $banner,
        DirectorImages $directorimage,
        ChairmanImages $chairmanimage,
        FacebookBanners $facebookbanner,
        Accounts $account,
        Video $video,
        SocietyChairmanImages $societychairmanimage,
        SocietyDirectorImages $societydirectorimage,
        Discreption $discreption

    ) {
        $this->banner                       = $banner;
        $this->directorimage               = $directorimage;
        $this->chairmanimage               = $chairmanimage;
        $this->facebookbanner               = $facebookbanner;
        $this->account               = $account;
        $this->video               = $video;
        $this->societychairmanimage               = $societychairmanimage;
        $this->societydirectorimage               = $societydirectorimage;
        $this->discreption               = $discreption;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        try {

            $details['banner'] = $this->banner->where('type', '=', 'home')->orderBy('id', 'DESC')->get();
            $details['directorimage'] = $this->directorimage->where('status', 1)->orderBy('id', 'DESC')->get();
            $details['chairmanimage'] = $this->chairmanimage->where('status', 1)->orderBy('id', 'DESC')->get();
            $details['facebookbanner'] = $this->facebookbanner->where('status', 1)->orderBy('id', 'DESC')->get();
            $details['account'] = $this->account->where('status', 1)->orderBy('id', 'DESC')->get();
            $details['video'] = $this->video->where('type', '=', 'homepage')->get();
            $details['societychairmanimage'] = $this->societychairmanimage->where('status', 1)->get();
            $details['societydirectorimage'] = $this->societydirectorimage->where('status', 1)->get();
             $details['discreption'] = $this->discreption->where('type','=','home')->get();


            #render view

            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
