<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Banner;
use App\Models\InquiryForms;
use App\Models\Investment1;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FrontendInvestment1Controller extends Controller
{
    #Bind view
    protected $view = 'frontend.investment1.';


    #Bind banner model
    protected $banner;


    public function __construct(

        Banner $banner,
        InquiryForms $inquiryform,
        Investment1 $investment1

    ) {
        $this->banner                   = $banner;
        $this->inquiryform              = $inquiryform;
        $this->investment1               = $investment1;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {


        try {

            $details['banner'] = $this->banner->where('type', '=', 'investment-1')->orderBy('id', 'DESC')->get();
            $details['inquiryform'] = $this->inquiryform->where('status', 1)->get();
             $details['investment1'] = $this->investment1->where('status',1)->get();


            #render view

            return view($this->view . 'index', $details);
        } catch (\Exception $ex) {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate([
            'first_name' => 'required',
            'last_name' => 'required',
            // 'mobile_number' => 'required',
            'mobile_number' => 'required|digits:10|unique:inquiry_form,monumber,',
            'email' => 'required|email',
            // 'email' => 'required|email|unique:inquiry_form,email',
            'message' => 'required'
        ]);
        $inquiryform                             = new InquiryForms();
        $inquiryform->fname                      = $request->first_name;
        $inquiryform->lname                   = $request->last_name;
        $inquiryform->monumber                = $request->mobile_number;

        $inquiryform->email                   = $request->email;
        $inquiryform->message                = $request->message;
        $inquiryform->type                  = $request->type;
        $inquiryform->save();

        // return redirect('/');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
