<?php

namespace App\Http\Controllers\Frontend;


use App\Models\Banner;
use App\Models\InquiryForms;
use App\Models\Investment3;



# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FrontendInvestment3Controller extends Controller
{
     #Bind view
     protected $view = 'frontend.investment3.';


     #Bind banner model
     protected $banner;


     public function __construct(
                        
        Banner $banner,
        InquiryForms $inquiryform,
        Investment3 $investment3 
                        
                        )
     {
        $this->banner               = $banner;
        $this->inquiryform              = $inquiryform;
        $this->investment3               = $investment3;
}


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
       
       try
        {    
            
            $details['banner'] = $this->banner->where('type','=','investment-3')->orderBy('id', 'DESC')->get();
            $details['inquiryform'] = $this->inquiryform->where('status',1)->get();
             $details['investment3'] = $this->investment3->where('status',1)->get();


                #render view
                 
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
            $validate = Validator::make($request->all(), [
            
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $inquiryform                             = new InquiryForms();
            $inquiryform->fname                      = $request->fname ;
            $inquiryform->lname                   = $request->lname ;
            $inquiryform->monumber                = $request->monumber ;

            $inquiryform->email                   = $request->email ;
            $inquiryform->message                = $request->message ;
            $inquiryform->type                  = $request->type ;
            $inquiryform->save();
     
             toastr()->success('Added Successfully');
            return redirect('/investment3');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
