<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Banner;
use App\Models\PaymentFacility;


# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FrontendPaymentFacilityController extends Controller
{
     #Bind view
     protected $view = 'frontend.paymentfacility.';


     #Bind Banner model
     protected $banner;


     public function __construct(
                        
        Banner $banner,
        PaymentFacility $paymentfacilityback
                        )
     {
         $this->banner               = $banner;
        $this->paymentfacilityback               = $paymentfacilityback;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
       
       try
        {    
            
            $details['banner'] = $this->banner->where('type','=','paymentfacilitybanner')->orderBy('id', 'DESC')->get();
            $details['paymentfacilityback'] = $this->paymentfacilityback->where('status', 1)->get();

                #render view
                 
                return view($this->view.'index',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
