<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Banner;
use App\Models\RegisForms;
use App\Models\Standards;
use App\Models\Streams;
use App\Models\Genders;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FrontendRegisFormController extends Controller
{
     #Bind view
     protected $view = 'frontend.regisform.';


     #Bind Banner model
     protected $banner;
    
     #Bind regisform model
     protected $regisform;

     public function __construct(
                        
                        Banner $banner,
                        RegisForms $regisform,
                        Standards $standard,
                        Streams $stream,
                        Genders $gender
                        )
     {
        
        $this->banner               = $banner;
        $this->regisform            = $regisform;
        $this->standard             = $standard;
        $this->stream               = $stream;
        $this->gender               = $gender;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
       
       try
        { 
                $details['regisform'] = $this->regisform->where('status',1)->orderBy('id', 'DESC')->get();   
                $details['banner'] = $this->banner->where('status',1)->orderBy('id', 'DESC')->get();
                $details['gender'] = $this->gender->where('status',1)->orderBy('id', 'DESC')->get();
                $details['stream'] = $this->stream->where('status',1)->orderBy('id', 'DESC')->get();
                $details['standard'] = $this->standard->where('status',1)->orderBy('id', 'DESC')->get();
                 
                return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {    
             $details['regisform'] = $this->regisform->where('status',1)->get();
             $details['standard'] = $this->standard->where('status',1)->get();
            
             $details['stream'] = $this->stream->where('status',1)->get();
             $details['gender'] = $this->gender->where('status',1)->get();
            #render view
            return view($this->view.'create',$details);
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());

            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        
        try{
            $validate = Validator::make($request->all(), [
            
            ]);

            if($validate->fails()){

                 toastr()->error($validate->messages());
                return redirect()->back()->withInput();
            }
            
            $regisform                             = new RegisForms();
            $regisform->email                    = $request->email ;
            $regisform->aadharid                = $request->aadharid ;
            $regisform->nameofchild                    = $request->nameofchild ;

            $regisform->class_id                = $request->class_id ;
            $regisform->dateofbirth                    = $request->dateofbirth ;

            $regisform->stream_id                = $request->stream_id ;
            $regisform->gender_id                    = $request->gender_id ;
            $regisform->nationality                = $request->nationality ;
            $regisform->nameofpreviousschool        = $request->nameofpreviousschool ;
            $regisform->fathername                = $request->fathername ;
            $regisform->mothername                    = $request->mothername ;
            $regisform->fatherphone                = $request->fatherphone ;
            $regisform->motherphone                    = $request->motherphone ;
            $regisform->address                = $request->address ;
            $regisform->save();
     
             toastr()->success('Added Successfully');
            return redirect('regisform');
        }catch(\Exception $ex)
        {
            toastr()->success($ex->getMessage());
            return back()->with('error', $ex->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
