<?php

namespace App\Http\Controllers;

# Models
use App\Models\User;
use App\Models\PersonalInfo;
use App\Models\EventSingleRegister;
use App\Models\EventFamilyRegister;

# Other Classes
use DB;
use Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{


    #Bind User model
    protected $user;

    #Bind PersonalInfo model
    protected $personalInfo;


    #Bind EventFamilyRegister model
    protected $eventFamilyRegister;

    #Bind EventSingleRegister model
    protected $eventSingleRegister;


    /**
      * Defining the default constructor for controller
      *
      */
    public function __construct(
                                EventFamilyRegister $eventFamilyRegister,
                                EventSingleRegister $eventSingleRegister,
                                PersonalInfo $personalInfo,
                                User $user
                            )
    {

        $this->eventFamilyRegister                       = $eventFamilyRegister;
        $this->eventSingleRegister                       = $eventSingleRegister;
        $this->personalInfo                              = $personalInfo;
        $this->user                                      = $user;
    }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $details['family']      = $this->eventFamilyRegister->count();
        $details['single']      = $this->eventSingleRegister->count();
        $details['register']    = $this->personalInfo->count();
        $details['total']       = $details['family']+$details['single']+$details['register'];

       


        return view('admin/dashboard/dashboard',$details);
    }
}
