<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Model;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
class ContactInfo extends Model
{
    # define table
      protected $table ='contact_infos'; 
      
      # define fillable fields
      protected $fillable = [
                          
                           "personal_info_id",
                           'country_id',
                           'state_id',
                           'city_id',
                           'email',
                           'phone',
                           'address',
                           'status'

                                                
];
 protected $casts = [
          'status'  => 'boolean',
          'created_at' => 'datetime:H:i:s a',
          'deleted_at' => 'datetime:H:i:s a',
      ];

       public function country()
      {
        return $this->hasOne(new Country(), 'id', 'country_id');
      }
      public function state()
      {
        return $this->hasOne(new State(), 'id', 'state_id');
      }
      public function city()
      {
        return $this->hasOne(new City(), 'id', 'city_id');
      }
       public function event()
      {
        return $this->hasOne(new Event(), 'id', 'event_id');
      }

}