<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class EventFamilyRegister extends Model
{
     use Notifiable ;
     
     # define table
      protected $table ='event_family_registers';
      
      # define fillable fields
      protected $fillable = [
                          
                           "event_id",
                           'f_name',
                           'm_name',
                           'l_name',
                           'n_address1',
                           'n_address2',
                           'n_country_id',
                           'n_state_id',
                           'n_city_id',
                           'n_pincode_id',
                           'p_address1',
                           'p_address2',
                           'p_country_id',
                           'p_state_id',
                           'p_city_id',
                           'p_pincode_id',
                           'a_canditate',



                                                
];
 protected $casts = [
          'created_at' => 'datetime:H:i:s a',
          'deleted_at' => 'datetime:H:i:s a',
      ];

       public function country()
      {
        return $this->hasOne(new Country(), 'id', 'n_country_id');
      }
        public function pcountry()
      {
        return $this->hasOne(new Country(), 'id','p_country_id');
      }
      public function state()
      {
        return $this->hasOne(new State(), 'id', 'n_state_id');
      }
      public function pstate()
      {
        return $this->hasOne(new State(), 'id','p_state_id');
      }
      public function city()
      {
        return $this->hasOne(new City(), 'id', 'n_city_id');
      }
      public function pcity()
      {
        return $this->hasOne(new City(), 'id','p_city_id');
      }
       public function event()
      {
        return $this->hasOne(new Event(), 'id', 'event_id');
      }
      public function pincode()
      {
        return $this->hasOne(new pincode(), 'id', 'n_pincode_id');
      }
      public function ppincode()
      {
        return $this->hasOne(new pincode(), 'id', 'p_pincode_id');
      }
}
