<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Laravel\Passport\HasApiTokens;

class User extends Authenticatable
{
    use HasFactory, Notifiable, HasRoles , HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',  'mobile_number', 'session_id','device_key','type','image',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

   

       /**
   * The attributes that should be cast.
   *
   * @var array
   */
  protected $casts = [
    'email_verified_at' => 'datetime',
      'status'  => 'boolean',
  ];

      public function wallet()
      {
        return $this->hasOne(new Wallet(), 'user_id', 'id');
      }

       public function technicianAttendance()
      {
        return $this->hasOne(new TechnicianAttendance(), 'user_id', 'id');
      }

       public function partnerRegistrtaion()
      {
        return $this->hasOne(new PartnerRegistrtaion(), 'user_id', 'id');
      }
        
      
      public function booking()
      {
        return $this->hasMany(new Booking(), 'assign_to_technican_id', 'id');
      }
      public function technicanIncome()
      {
        return $this->hasOne(new TechnicanIncome(), 'technican_id', 'id');
      }

}
